/*
 * Decompiled with CFR 0.152.
 */
package com.nexo.wardendimension.init;

import com.nexo.wardendimension.entity.FireBallProjectileEntity;
import com.nexo.wardendimension.entity.GuardianOfTheTempleEntity;
import com.nexo.wardendimension.entity.SculkifiedBlackSmithVilligerEntity;
import com.nexo.wardendimension.entity.SculkifiedSkeletonEntity;
import com.nexo.wardendimension.entity.SculkifiedVilligerStarEntity;
import com.nexo.wardendimension.entity.SculkmiteEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class WardenDimensionModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"warden_dimension");
    public static final DeferredHolder<EntityType<?>, EntityType<SculkifiedSkeletonEntity>> SCULKIFIED_SKELETON = WardenDimensionModEntities.register("sculkified_skeleton", EntityType.Builder.of(SculkifiedSkeletonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(70).setUpdateInterval(3).fireImmune().sized(0.6f, 1.95f));
    public static final DeferredHolder<EntityType<?>, EntityType<SculkifiedVilligerStarEntity>> SCULKIFIED_VILLIGER_STAR = WardenDimensionModEntities.register("sculkified_villiger_star", EntityType.Builder.of(SculkifiedVilligerStarEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<FireBallProjectileEntity>> FIRE_BALL_PROJECTILE = WardenDimensionModEntities.register("fire_ball_projectile", EntityType.Builder.of(FireBallProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<SculkifiedBlackSmithVilligerEntity>> SCULKIFIED_BLACK_SMITH_VILLIGER = WardenDimensionModEntities.register("sculkified_black_smith_villiger", EntityType.Builder.of(SculkifiedBlackSmithVilligerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(70).setUpdateInterval(3).fireImmune().sized(0.6f, 1.95f));
    public static final DeferredHolder<EntityType<?>, EntityType<SculkmiteEntity>> SCULKMITE = WardenDimensionModEntities.register("sculkmite", EntityType.Builder.of(SculkmiteEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.4f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<GuardianOfTheTempleEntity>> GUARDIAN_OF_THE_TEMPLE = WardenDimensionModEntities.register("guardian_of_the_temple", EntityType.Builder.of(GuardianOfTheTempleEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(100).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"warden_dimension", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        SculkifiedSkeletonEntity.init(event);
        SculkifiedBlackSmithVilligerEntity.init(event);
        SculkmiteEntity.init(event);
        GuardianOfTheTempleEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SCULKIFIED_SKELETON.get(), SculkifiedSkeletonEntity.createAttributes().build());
        event.put((EntityType)SCULKIFIED_BLACK_SMITH_VILLIGER.get(), SculkifiedBlackSmithVilligerEntity.createAttributes().build());
        event.put((EntityType)SCULKMITE.get(), SculkmiteEntity.createAttributes().build());
        event.put((EntityType)GUARDIAN_OF_THE_TEMPLE.get(), GuardianOfTheTempleEntity.createAttributes().build());
    }
}

