/*
 * Decompiled with CFR 0.152.
 */
package com.nexo.wardendimension.init;

import com.nexo.wardendimension.entity.FireBallProjectileEntity;
import com.nexo.wardendimension.entity.GuardianOfTheTempleEntity;
import com.nexo.wardendimension.entity.SculkifiedBlackSmithVilligerEntity;
import com.nexo.wardendimension.entity.SculkifiedSkeletonEntity;
import com.nexo.wardendimension.entity.SculkifiedVilligerStarEntity;
import com.nexo.wardendimension.entity.SculkmiteEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class WardenDimensionForForgeModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"warden_dimension_for_forge");
    public static final RegistryObject<EntityType<SculkifiedSkeletonEntity>> SCULKIFIED_SKELETON = WardenDimensionForForgeModEntities.register("sculkified_skeleton", EntityType.Builder.m_20704_(SculkifiedSkeletonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(70).setUpdateInterval(3).setCustomClientFactory(SculkifiedSkeletonEntity::new).m_20719_().m_20699_(0.6f, 1.95f));
    public static final RegistryObject<EntityType<SculkifiedVilligerStarEntity>> SCULKIFIED_VILLIGER_STAR = WardenDimensionForForgeModEntities.register("sculkified_villiger_star", EntityType.Builder.m_20704_(SculkifiedVilligerStarEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(SculkifiedVilligerStarEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<FireBallProjectileEntity>> FIRE_BALL_PROJECTILE = WardenDimensionForForgeModEntities.register("fire_ball_projectile", EntityType.Builder.m_20704_(FireBallProjectileEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(FireBallProjectileEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<SculkifiedBlackSmithVilligerEntity>> SCULKIFIED_BLACK_SMITH_VILLIGER = WardenDimensionForForgeModEntities.register("sculkified_black_smith_villiger", EntityType.Builder.m_20704_(SculkifiedBlackSmithVilligerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(70).setUpdateInterval(3).setCustomClientFactory(SculkifiedBlackSmithVilligerEntity::new).m_20719_().m_20699_(0.6f, 1.95f));
    public static final RegistryObject<EntityType<SculkmiteEntity>> SCULKMITE = WardenDimensionForForgeModEntities.register("sculkmite", EntityType.Builder.m_20704_(SculkmiteEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SculkmiteEntity::new).m_20719_().m_20699_(0.4f, 0.3f));
    public static final RegistryObject<EntityType<GuardianOfTheTempleEntity>> GUARDIAN_OF_THE_TEMPLE = WardenDimensionForForgeModEntities.register("guardian_of_the_temple", EntityType.Builder.m_20704_(GuardianOfTheTempleEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(100).setUpdateInterval(3).setCustomClientFactory(GuardianOfTheTempleEntity::new).m_20719_().m_20699_(0.6f, 1.8f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SculkifiedSkeletonEntity.init();
            SculkifiedBlackSmithVilligerEntity.init();
            SculkmiteEntity.init();
            GuardianOfTheTempleEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SCULKIFIED_SKELETON.get(), SculkifiedSkeletonEntity.createAttributes().m_22265_());
        event.put((EntityType)SCULKIFIED_BLACK_SMITH_VILLIGER.get(), SculkifiedBlackSmithVilligerEntity.createAttributes().m_22265_());
        event.put((EntityType)SCULKMITE.get(), SculkmiteEntity.m_34328_().m_22265_());
        event.put((EntityType)GUARDIAN_OF_THE_TEMPLE.get(), GuardianOfTheTempleEntity.createAttributes().m_22265_());
    }
}

