/*
 * Decompiled with CFR 0.152.
 */
package com.nexo.wardendimension.world.features.treedecorators;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber
public class DeepForestLeaveDecorator
extends LeaveVineDecorator {
    public static MapCodec<DeepForestLeaveDecorator> CODEC = MapCodec.unit(DeepForestLeaveDecorator::new);
    public static TreeDecoratorType<?> DECORATOR_TYPE = new TreeDecoratorType(CODEC);

    @SubscribeEvent
    public static void registerTreeDecorator(RegisterEvent event) {
        event.register(Registries.TREE_DECORATOR_TYPE, ResourceLocation.parse((String)"warden_dimension:deep_forest_tree_leave_decorator"), () -> DECORATOR_TYPE);
    }

    public DeepForestLeaveDecorator() {
        super(0.25f);
    }

    protected TreeDecoratorType<?> type() {
        return DECORATOR_TYPE;
    }

    public void place(TreeDecorator.Context context) {
        context.leaves().forEach(blockpos -> {
            BlockPos pos;
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.west())) {
                DeepForestLeaveDecorator.addVine(pos, Direction.WEST, context);
            }
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.east())) {
                DeepForestLeaveDecorator.addVine(pos, Direction.EAST, context);
            }
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.north())) {
                DeepForestLeaveDecorator.addVine(pos, Direction.NORTH, context);
            }
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.south())) {
                DeepForestLeaveDecorator.addVine(pos, Direction.SOUTH, context);
            }
        });
    }

    private static void addVine(BlockPos pos, Direction direction, TreeDecorator.Context context) {
        context.setBlock(pos, Blocks.SCULK_VEIN.defaultBlockState());
        BlockPos blockpos = pos.below();
        for (int i = 4; context.isAir(blockpos) && i > 0; --i) {
            context.setBlock(blockpos, DeepForestLeaveDecorator.oriented(Blocks.SCULK_VEIN.defaultBlockState(), direction));
            blockpos = blockpos.below();
        }
    }

    private static BlockState oriented(BlockState blockstate, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> blockstate.rotate(Rotation.CLOCKWISE_180);
            case Direction.EAST -> blockstate.rotate(Rotation.CLOCKWISE_90);
            case Direction.WEST -> blockstate.rotate(Rotation.COUNTERCLOCKWISE_90);
            default -> blockstate;
        };
    }
}

