package com.github.sidit77.bettermipmaps.compat.sodium.mixin;

import com.github.sidit77.bettermipmaps.BetterMipmaps;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.caffeinemc.mods.sodium.client.gui.SodiumGameOptionPages;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpl;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatter;
import net.caffeinemc.mods.sodium.client.gui.options.control.SliderControl;
import net.minecraft.class_310;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value = SodiumGameOptionPages.class, remap = false)
abstract class SodiumGameOptionPagesMixin {

    @SuppressWarnings("unchecked")
    @WrapOperation(method = "quality", at = @At(value = "INVOKE", target = "Lnet/caffeinemc/mods/sodium/client/gui/options/OptionImpl$Builder;build()Lnet/caffeinemc/mods/sodium/client/gui/options/OptionImpl;"), remap = false)
    private static <S, T> OptionImpl<S, T> increaseMipmapLevels(OptionImpl.Builder builder, Operation<OptionImpl<S, T>> factory){
        OptionImpl<S, T> option = factory.call(builder);
        if(!option.getName().getString().equals(class_310.method_1551().field_1690.method_42563().toString()))
            return option;
        return builder
                .setControl(o -> new SliderControl((Option<Integer>) o, 0, BetterMipmaps.MAX_MIPMAP_LEVEL, 1, ControlValueFormatter.multiplier()))
                .build();
    }

}
