/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.notify.shared;

import app.simplecloud.droplet.api.auth.AuthCallCredentials;
import app.simplecloud.droplet.api.time.ProtobufTimestamp;
import app.simplecloud.plugin.notify.shared.StringExtensionKt;
import app.simplecloud.plugin.notify.shared.config.Config;
import app.simplecloud.plugin.notify.shared.config.ConfigFactory;
import app.simplecloud.plugin.notify.shared.config.ServerStateChangedFilterEntry;
import app.simplecloud.pubsub.PubSubClient;
import app.simplecloud.relocate.google.protobuf.Timestamp;
import app.simplecloud.relocate.io.grpc.CallCredentials;
import build.buf.gen.simplecloud.controller.v1.ServerDefinition;
import build.buf.gen.simplecloud.controller.v1.ServerStartEvent;
import build.buf.gen.simplecloud.controller.v1.ServerStartEventKtKt;
import build.buf.gen.simplecloud.controller.v1.ServerStartEventOrBuilder;
import build.buf.gen.simplecloud.controller.v1.ServerState;
import build.buf.gen.simplecloud.controller.v1.ServerStopEvent;
import build.buf.gen.simplecloud.controller.v1.ServerStopEventKtKt;
import build.buf.gen.simplecloud.controller.v1.ServerStopEventOrBuilder;
import build.buf.gen.simplecloud.controller.v1.ServerUpdateEvent;
import build.buf.gen.simplecloud.controller.v1.ServerUpdateEventKtKt;
import build.buf.gen.simplecloud.controller.v1.ServerUpdateEventOrBuilder;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\r\u001a2\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lapp/simplecloud/plugin/notify/shared/NotifyPlugin;", "", "dataDirectory", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "config", "Lapp/simplecloud/plugin/notify/shared/config/Config;", "dateFormat", "Ljava/text/SimpleDateFormat;", "serverStateFilter", "", "Lapp/simplecloud/plugin/notify/shared/config/ServerStateChangedFilterEntry;", "listeningFunction", "Lkotlin/Function2;", "Lnet/kyori/adventure/text/Component;", "Lkotlin/ParameterName;", "name", "message", "", "permission", "", "getListeningFunction", "()Lkotlin/jvm/functions/Function2;", "setListeningFunction", "(Lkotlin/jvm/functions/Function2;)V", "handleUpdate", "serverState", "Lbuild/buf/gen/simplecloud/controller/v1/ServerState;", "server", "Lbuild/buf/gen/simplecloud/controller/v1/ServerDefinition;", "generateMessage", "notify-shared"})
@SourceDebugExtension(value={"SMAP\nNotifyPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotifyPlugin.kt\napp/simplecloud/plugin/notify/shared/NotifyPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n774#2:97\n865#2,2:98\n1863#2,2:100\n*S KotlinDebug\n*F\n+ 1 NotifyPlugin.kt\napp/simplecloud/plugin/notify/shared/NotifyPlugin\n*L\n53#1:97\n53#1:98,2\n56#1:100,2\n*E\n"})
public final class NotifyPlugin {
    @NotNull
    private final Config config;
    @NotNull
    private final SimpleDateFormat dateFormat;
    @NotNull
    private final List<ServerStateChangedFilterEntry> serverStateFilter;
    public Function2<? super Component, ? super String, Unit> listeningFunction;

    public NotifyPlugin(@NotNull Path dataDirectory) {
        Intrinsics.checkNotNullParameter((Object)dataDirectory, (String)"dataDirectory");
        this.config = ConfigFactory.INSTANCE.loadOrCreate(dataDirectory);
        this.dateFormat = new SimpleDateFormat(this.config.getDateFormat());
        this.serverStateFilter = this.config.getServerStateFilter();
        String string = System.getenv("CONTROLLER_PUBSUB_HOST");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
        String string2 = System.getenv("CONTROLLER_PUBSUB_PORT");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getenv(...)");
        int n = Integer.parseInt(string2);
        String string3 = System.getenv("CONTROLLER_SECRET");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getenv(...)");
        PubSubClient pubSubClient = new PubSubClient(string, n, (CallCredentials)new AuthCallCredentials(string3));
        pubSubClient.subscribe("event", ServerStartEvent.class, arg_0 -> NotifyPlugin._init_$lambda$0(this, arg_0));
        pubSubClient.subscribe("event", ServerStopEvent.class, arg_0 -> NotifyPlugin._init_$lambda$1(this, arg_0));
        pubSubClient.subscribe("event", ServerUpdateEvent.class, arg_0 -> NotifyPlugin._init_$lambda$2(this, arg_0));
    }

    @NotNull
    public final Function2<Component, String, Unit> getListeningFunction() {
        Function2<? super Component, ? super String, Unit> function2 = this.listeningFunction;
        if (function2 != null) {
            return function2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"listeningFunction");
        return null;
    }

    public final void setListeningFunction(@NotNull Function2<? super Component, ? super String, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.listeningFunction = function2;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleUpdate(ServerState serverState, ServerDefinition server) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.serverStateFilter;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ServerStateChangedFilterEntry it = (ServerStateChangedFilterEntry)element$iv$iv;
            boolean bl = false;
            if (!(it.getServerState() == serverState)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filter = (List)destination$iv$iv;
        if (filter.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = filter;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerStateChangedFilterEntry it = (ServerStateChangedFilterEntry)element$iv;
            boolean bl = false;
            Component message = this.generateMessage(serverState, server, it.getMessage());
            this.getListeningFunction().invoke((Object)message, (Object)it.getPermission());
        }
    }

    private final Component generateMessage(ServerState serverState, ServerDefinition server, String message) {
        TagResolver[] tagResolverArray = new TagResolver[10];
        String string = server.getServerIp();
        if (string == null) {
            string = "N/A";
        }
        tagResolverArray[0] = Placeholder.parsed("server_ip", string);
        tagResolverArray[1] = Placeholder.parsed("server_port", String.valueOf(server.getServerPort()));
        String string2 = server.getGroupName();
        if (string2 == null) {
            string2 = "N/A";
        }
        tagResolverArray[2] = Placeholder.parsed("server_group", string2);
        tagResolverArray[3] = Placeholder.parsed("server_uuid", server.getUniqueId());
        tagResolverArray[4] = Placeholder.parsed("server_id", String.valueOf(server.getNumericalId()));
        Timestamp timestamp = server.getCreatedAt();
        Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"getCreatedAt(...)");
        tagResolverArray[5] = Placeholder.parsed("server_create_date", this.dateFormat.format(NotifyPlugin.generateMessage$timeStampToLong(timestamp)));
        Timestamp timestamp2 = server.getUpdatedAt();
        Intrinsics.checkNotNullExpressionValue((Object)timestamp2, (String)"getUpdatedAt(...)");
        tagResolverArray[6] = Placeholder.parsed("server_update_date", this.dateFormat.format(NotifyPlugin.generateMessage$timeStampToLong(timestamp2)));
        tagResolverArray[7] = Placeholder.parsed("online_players", String.valueOf(server.getPlayerCount()));
        tagResolverArray[8] = Placeholder.parsed("max_players", String.valueOf(server.getMaxPlayers()));
        tagResolverArray[9] = Placeholder.parsed("server_state", serverState.name());
        return StringExtensionKt.miniMessage(message, tagResolverArray);
    }

    private static final void _init_$lambda$0(NotifyPlugin this$0, ServerStartEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ServerDefinition serverDefinition = ServerStartEventKtKt.getServerOrNull((ServerStartEventOrBuilder)((ServerStartEventOrBuilder)event));
        if (serverDefinition == null) {
            return;
        }
        ServerDefinition startingServer = serverDefinition;
        this$0.handleUpdate(ServerState.STARTING, startingServer);
    }

    private static final void _init_$lambda$1(NotifyPlugin this$0, ServerStopEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ServerDefinition serverDefinition = ServerStopEventKtKt.getServerOrNull((ServerStopEventOrBuilder)((ServerStopEventOrBuilder)event));
        if (serverDefinition == null) {
            return;
        }
        ServerDefinition stoppingServer = serverDefinition;
        this$0.handleUpdate(ServerState.STOPPING, stoppingServer);
    }

    private static final void _init_$lambda$2(NotifyPlugin this$0, ServerUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ServerDefinition serverDefinition = ServerUpdateEventKtKt.getServerAfterOrNull((ServerUpdateEventOrBuilder)((ServerUpdateEventOrBuilder)event));
        if (serverDefinition == null) {
            return;
        }
        ServerDefinition serverAfter = serverDefinition;
        ServerDefinition serverDefinition2 = ServerUpdateEventKtKt.getServerBeforeOrNull((ServerUpdateEventOrBuilder)((ServerUpdateEventOrBuilder)event));
        if ((serverDefinition2 != null ? serverDefinition2.getServerState() : null) == serverAfter.getServerState()) {
            return;
        }
        ServerState serverState = serverAfter.getServerState();
        Intrinsics.checkNotNull((Object)serverState);
        this$0.handleUpdate(serverState, serverAfter);
    }

    private static final long generateMessage$timeStampToLong(Timestamp timeStamp) {
        return ProtobufTimestamp.INSTANCE.toLocalDateTime(timeStamp).toInstant(OffsetDateTime.now().getOffset()).toEpochMilli();
    }
}

