/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.serialize;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.util.CheckedConsumer;

public abstract class AbstractListChildSerializer<T>
implements TypeSerializer<T> {
    protected AbstractListChildSerializer() {
    }

    @Override
    public final T deserialize(Type type, ConfigurationNode node) throws SerializationException {
        Type entryType = this.elementType(type);
        @Nullable TypeSerializer<?> entrySerial = node.options().serializers().get(entryType);
        if (entrySerial == null) {
            throw new SerializationException(node, entryType, "No applicable type serializer for type");
        }
        if (node.isList()) {
            List<? extends ConfigurationNode> values = node.childrenList();
            T ret2 = this.createNew(values.size(), entryType);
            for (int i2 = 0; i2 < values.size(); ++i2) {
                try {
                    this.deserializeSingle(i2, ret2, entrySerial.deserialize(entryType, values.get(i2)));
                    continue;
                }
                catch (SerializationException ex) {
                    ex.initPath(values.get(i2)::path);
                    throw ex;
                }
            }
            return ret2;
        }
        @Nullable Object unwrappedVal = node.raw();
        if (unwrappedVal != null) {
            T ret3 = this.createNew(1, entryType);
            this.deserializeSingle(0, ret3, entrySerial.deserialize(entryType, node));
            return ret3;
        }
        return this.createNew(0, entryType);
    }

    @Override
    public final void serialize(Type type, @Nullable T obj, ConfigurationNode node) throws SerializationException {
        Type entryType = this.elementType(type);
        @Nullable TypeSerializer<?> entrySerial = node.options().serializers().get(entryType);
        if (entrySerial == null) {
            throw new SerializationException(node, entryType, "No applicable type serializer for type");
        }
        node.raw(Collections.emptyList());
        if (obj != null) {
            this.forEachElement(obj, el -> {
                ConfigurationNode child = node.appendListNode();
                try {
                    entrySerial.serialize(entryType, el, child);
                }
                catch (SerializationException ex) {
                    ex.initPath(child::path);
                    throw ex;
                }
            });
        }
    }

    @Override
    public @Nullable T emptyValue(Type specificType, ConfigurationOptions options) {
        try {
            return this.createNew(0, this.elementType(specificType));
        }
        catch (SerializationException ex) {
            return null;
        }
    }

    protected abstract Type elementType(Type var1) throws SerializationException;

    protected abstract T createNew(int var1, Type var2) throws SerializationException;

    protected abstract void forEachElement(T var1, CheckedConsumer<Object, SerializationException> var2) throws SerializationException;

    protected abstract void deserializeSingle(int var1, T var2, @Nullable Object var3) throws SerializationException;
}

