/*
 * Decompiled with CFR 0.152.
 */
package ru.ruscalworld.fabricexporter;

import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.ruscalworld.fabricexporter.MetricRegistry;
import ru.ruscalworld.fabricexporter.config.MainConfig;
import ru.ruscalworld.fabricexporter.util.IdentifierFormatter;

public class FabricExporter
implements ModInitializer {
    private static final Logger logger = LogManager.getLogger();
    private static FabricExporter instance;
    private MinecraftServer server;
    private MainConfig config;
    private HTTPServer httpServer;
    private MetricRegistry metricRegistry;
    private IdentifierFormatter identifierFormatter;

    public void onInitialize() {
        try {
            MainConfig config = new MainConfig("exporter.properties");
            config.load();
            this.setConfig(config);
        }
        catch (IOException e) {
            logger.fatal("Unable to load config", (Throwable)e);
            return;
        }
        Optional spark = FabricLoader.getInstance().getModContainer("spark");
        if (spark.isEmpty() && this.config.shouldUseSpark()) {
            this.config.setShouldUseSpark(false);
            logger.warn("Spark mod is not installed, but \"use-spark\" property is enabled! TPS and MSPT metrics will be disabled.");
            logger.warn("To fix this, you should either set \"use-spark\" in exporter.properties to false or install Spark mod (https://spark.lucko.me).");
        }
        this.setIdentifierFormatter(new IdentifierFormatter(this.config.shouldStripIdentifierNamespaces()));
        MetricRegistry metricRegistry = new MetricRegistry(this);
        metricRegistry.registerDefault();
        this.setMetricRegistry(metricRegistry);
        if (this.config.shouldExportJvmDefaults()) {
            DefaultExports.initialize();
        }
        ServerLifecycleEvents.SERVER_STARTING.register(this::setServer);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            try {
                int port = this.getConfig().getPort();
                this.setHttpServer(new HTTPServer(port));
                logger.info("Prometheus exporter server is now listening on port {}", (Object)port);
                this.getMetricRegistry().runUpdater();
            }
            catch (IOException e) {
                logger.error("Unable to start prometheus exporter server", (Throwable)e);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            this.getHttpServer().close();
            this.getMetricRegistry().getMetricUpdaterTimer().cancel();
        });
        instance = this;
    }

    public static Logger getLogger() {
        return LogManager.getLogger();
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    private void setServer(MinecraftServer server) {
        this.server = server;
    }

    public MainConfig getConfig() {
        return this.config;
    }

    public void setConfig(MainConfig config) {
        this.config = config;
    }

    public HTTPServer getHttpServer() {
        return this.httpServer;
    }

    public void setHttpServer(HTTPServer httpServer) {
        this.httpServer = httpServer;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    private void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public static FabricExporter getInstance() {
        return instance;
    }

    public IdentifierFormatter getIdentifierFormatter() {
        return this.identifierFormatter;
    }

    private void setIdentifierFormatter(IdentifierFormatter identifierFormatter) {
        this.identifierFormatter = identifierFormatter;
    }
}

