/*
 * Decompiled with CFR 0.152.
 */
package ru.ruscalworld.fabricexporter;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ruscalworld.fabricexporter.FabricExporter;
import ru.ruscalworld.fabricexporter.metrics.Metric;

public class MetricUpdater
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"MetricUpdater");
    private final List<Metric> metrics = new ArrayList<Metric>();
    private final FabricExporter exporter;

    public MetricUpdater(FabricExporter exporter) {
        this.exporter = exporter;
    }

    @Override
    public void run() {
        for (Metric metric : this.getMetrics()) {
            try {
                metric.update(this.getExporter());
            }
            catch (Exception exception) {
                logger.error("Error updating metric " + metric.getName(), (Throwable)exception);
            }
        }
    }

    public void registerMetric(Metric metric) {
        this.metrics.add(metric);
    }

    public FabricExporter getExporter() {
        return this.exporter;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }
}

