/*
 * Decompiled with CFR 0.152.
 */
package ru.ruscalworld.fabricexporter.metrics.spark;

import io.prometheus.client.Gauge;
import me.lucko.spark.api.statistic.StatisticWindow;
import me.lucko.spark.api.statistic.misc.DoubleAverageInfo;
import me.lucko.spark.api.statistic.types.GenericStatistic;
import ru.ruscalworld.fabricexporter.FabricExporter;
import ru.ruscalworld.fabricexporter.metrics.spark.SparkMetric;

public class MillisPerTick
extends SparkMetric {
    public MillisPerTick() {
        super("mspt", "Milliseconds per tick (MSPT)", "type");
    }

    @Override
    public void update(FabricExporter exporter) {
        GenericStatistic mspt = this.getSpark().mspt();
        if (mspt == null) {
            this.setValue(0.0, 0.0, 0.0);
        } else {
            this.setValue(((DoubleAverageInfo)mspt.poll((Enum)StatisticWindow.MillisPerTick.MINUTES_1)).min(), ((DoubleAverageInfo)mspt.poll((Enum)StatisticWindow.MillisPerTick.MINUTES_1)).mean(), ((DoubleAverageInfo)mspt.poll((Enum)StatisticWindow.MillisPerTick.MINUTES_1)).max());
        }
    }

    private void setValue(double min, double mean, double max) {
        ((Gauge.Child)this.getGauge().labels("min")).set(min);
        ((Gauge.Child)this.getGauge().labels("mean")).set(mean);
        ((Gauge.Child)this.getGauge().labels("max")).set(max);
    }
}

