/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.registration.relocate.spongepowered.configurate.loader;

import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.ConfigurateException;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.ConfigurationNode;
import java.io.IOException;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ParsingException
extends ConfigurateException {
    public static final int UNKNOWN_POS = -1;
    private static final char POSITION_MARKER = '^';
    private static final long serialVersionUID = 8379206111053602577L;
    private final int line;
    private final int column;
    private final @Nullable String context;

    public static ParsingException wrap(ConfigurationNode source, IOException ex) {
        if (ex instanceof ParsingException) {
            return (ParsingException)ex;
        }
        return new ParsingException(source, -1, -1, null, null, ex);
    }

    public ParsingException(ConfigurationNode position, int line, int column, String context, @Nullable String message) {
        this(position, line, column, context, message, null);
    }

    public ParsingException(int line, int column, @Nullable String context, @Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
        this.line = line;
        this.column = column;
        this.context = context;
    }

    public ParsingException(ConfigurationNode position, int line, int column, @Nullable String context, @Nullable String message, @Nullable Throwable cause) {
        super(position, message, cause);
        this.line = line;
        this.column = column;
        this.context = context;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public @Nullable String context() {
        return this.context;
    }

    @Override
    public @Nullable String getMessage() {
        if (this.line == -1 || this.column == -1) {
            return super.getMessage();
        }
        @Nullable String rawMessage = this.rawMessage();
        StringBuilder message = new StringBuilder(rawMessage == null ? 0 : rawMessage.length() + 20);
        message.append(this.path()).append("@(line ").append(this.line).append(", col ").append(this.column).append("): ").append(rawMessage);
        if (this.context != null) {
            message.append(System.lineSeparator()).append(this.context);
            if (this.column >= 0 && this.column < this.context.length()) {
                message.append(System.lineSeparator());
                if (this.column > 0) {
                    char[] spaces = new char[this.column - 1];
                    Arrays.fill(spaces, ' ');
                    message.append(spaces);
                }
                message.append('^');
            }
        }
        return message.toString();
    }
}

