/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.registration.velocity;

import app.simplecloud.controller.shared.server.Server;
import app.simplecloud.plugin.registration.shared.ServerRegisterer;
import app.simplecloud.plugin.registration.velocity.VelocityServerRegistrationPlugin;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lapp/simplecloud/plugin/registration/velocity/VelocityServerRegisterer;", "Lapp/simplecloud/plugin/registration/shared/ServerRegisterer;", "plugin", "Lapp/simplecloud/plugin/registration/velocity/VelocityServerRegistrationPlugin;", "proxy", "Lcom/velocitypowered/api/proxy/ProxyServer;", "<init>", "(Lapp/simplecloud/plugin/registration/velocity/VelocityServerRegistrationPlugin;Lcom/velocitypowered/api/proxy/ProxyServer;)V", "servers", "", "Lapp/simplecloud/controller/shared/server/Server;", "getRegistered", "", "register", "", "server", "unregister", "registration-velocity"})
public final class VelocityServerRegisterer
implements ServerRegisterer {
    @NotNull
    private final VelocityServerRegistrationPlugin plugin;
    @NotNull
    private final ProxyServer proxy;
    @NotNull
    private final List<Server> servers;

    public VelocityServerRegisterer(@NotNull VelocityServerRegistrationPlugin plugin, @NotNull ProxyServer proxy) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        this.plugin = plugin;
        this.proxy = proxy;
        this.servers = new ArrayList();
    }

    @Override
    @NotNull
    public List<Server> getRegistered() {
        return this.servers;
    }

    @Override
    public void register(@NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        ServerInfo info = new ServerInfo(this.plugin.getServerRegistration().parseServerId(server), InetSocketAddress.createUnresolved(server.getIp(), (int)server.getPort()));
        this.proxy.registerServer(info);
        this.servers.add(server);
    }

    @Override
    public void unregister(@NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Optional optional = this.proxy.getServer(this.plugin.getServerRegistration().parseServerId(server));
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getServer(...)");
        RegisteredServer registeredServer = (RegisteredServer)OptionalsKt.getOrNull((Optional)optional);
        if (registeredServer == null) {
            return;
        }
        RegisteredServer registeredSerer = registeredServer;
        this.proxy.unregisterServer(registeredSerer.getServerInfo());
        this.servers.remove(server);
    }
}

