/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.registration.velocity;

import app.simplecloud.controller.api.ControllerApi;
import app.simplecloud.plugin.registration.shared.RegistrationServer;
import app.simplecloud.plugin.registration.shared.ServerRegistrationPlugin;
import app.simplecloud.plugin.registration.velocity.VelocityServerRegisterer;
import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Collection;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Plugin(id="registration-velocity", name="registration-velocity", version="0.0.1", description="Server Registration plugin for SimpleCloud v3", url="https://github.com/theSimpleCloud/server-registration-plugin", authors={"daviidooo"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B#\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lapp/simplecloud/plugin/registration/velocity/VelocityServerRegistrationPlugin;", "", "dataDirectory", "Ljava/nio/file/Path;", "server", "Lcom/velocitypowered/api/proxy/ProxyServer;", "logger", "Ljava/util/logging/Logger;", "<init>", "(Ljava/nio/file/Path;Lcom/velocitypowered/api/proxy/ProxyServer;Ljava/util/logging/Logger;)V", "getDataDirectory", "()Ljava/nio/file/Path;", "serverRegistration", "Lapp/simplecloud/plugin/registration/shared/ServerRegistrationPlugin;", "getServerRegistration", "()Lapp/simplecloud/plugin/registration/shared/ServerRegistrationPlugin;", "api", "Lapp/simplecloud/controller/api/ControllerApi$Coroutine;", "handleInitialize", "", "ignored", "Lcom/velocitypowered/api/event/proxy/ProxyInitializeEvent;", "cleanupServers", "registration-velocity"})
@SourceDebugExtension(value={"SMAP\nVelocityServerRegistrationPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VelocityServerRegistrationPlugin.kt\napp/simplecloud/plugin/registration/velocity/VelocityServerRegistrationPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1869#2,2:60\n1869#2,2:62\n*S KotlinDebug\n*F\n+ 1 VelocityServerRegistrationPlugin.kt\napp/simplecloud/plugin/registration/velocity/VelocityServerRegistrationPlugin\n*L\n48#1:60,2\n55#1:62,2\n*E\n"})
public final class VelocityServerRegistrationPlugin {
    @NotNull
    private final Path dataDirectory;
    @NotNull
    private final ProxyServer server;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ServerRegistrationPlugin serverRegistration;
    @NotNull
    private final ControllerApi.Coroutine api;

    @Inject
    public VelocityServerRegistrationPlugin(@DataDirectory @NotNull Path dataDirectory, @NotNull ProxyServer server, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)dataDirectory, (String)"dataDirectory");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.dataDirectory = dataDirectory;
        this.server = server;
        this.logger = logger;
        this.serverRegistration = new ServerRegistrationPlugin(this.logger, this.dataDirectory, new VelocityServerRegisterer(this, this.server));
        this.api = ControllerApi.Companion.createCoroutineApi();
    }

    @NotNull
    public final Path getDataDirectory() {
        return this.dataDirectory;
    }

    @NotNull
    public final ServerRegistrationPlugin getServerRegistration() {
        return this.serverRegistration;
    }

    @Subscribe
    public final void handleInitialize(@NotNull ProxyInitializeEvent ignored) {
        Intrinsics.checkNotNullParameter((Object)ignored, (String)"ignored");
        this.cleanupServers();
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ VelocityServerRegistrationPlugin this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getServerRegistration().start(VelocityServerRegistrationPlugin.access$getApi$p(this.this$0), (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        Iterable $this$forEach$iv = this.serverRegistration.getConfig().getAdditionalServers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RegistrationServer it = (RegistrationServer)element$iv;
            boolean bl = false;
            ServerInfo serverInfo = new ServerInfo(it.getName(), InetSocketAddress.createUnresolved(it.getAddress(), (int)it.getPort()));
            this.server.registerServer(serverInfo);
        }
    }

    private final void cleanupServers() {
        Collection collection = this.server.getAllServers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllServers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RegisteredServer it = (RegisteredServer)element$iv;
            boolean bl = false;
            this.server.unregisterServer(it.getServerInfo());
        }
    }

    public static final /* synthetic */ ControllerApi.Coroutine access$getApi$p(VelocityServerRegistrationPlugin $this) {
        return $this.api;
    }
}

