/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.registration.bungee;

import app.simplecloud.controller.shared.server.Server;
import app.simplecloud.plugin.registration.bungee.BungeeServerRegistrationPlugin;
import app.simplecloud.plugin.registration.shared.ServerRegisterer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\"\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lapp/simplecloud/plugin/registration/bungee/BungeeServerRegisterer;", "Lapp/simplecloud/plugin/registration/shared/ServerRegisterer;", "plugin", "Lapp/simplecloud/plugin/registration/bungee/BungeeServerRegistrationPlugin;", "<init>", "(Lapp/simplecloud/plugin/registration/bungee/BungeeServerRegistrationPlugin;)V", "registered", "", "Lapp/simplecloud/controller/shared/server/Server;", "getRegistered", "", "register", "", "server", "unregister", "removeServer", "Lnet/md_5/bungee/api/config/ServerInfo;", "", "", "uniqueId", "registration-bungeecord"})
@SourceDebugExtension(value={"SMAP\nBungeeServerRegisterer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BungeeServerRegisterer.kt\napp/simplecloud/plugin/registration/bungee/BungeeServerRegisterer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,41:1\n538#2:42\n523#2,6:43\n*S KotlinDebug\n*F\n+ 1 BungeeServerRegisterer.kt\napp/simplecloud/plugin/registration/bungee/BungeeServerRegisterer\n*L\n33#1:42\n33#1:43,6\n*E\n"})
public final class BungeeServerRegisterer
implements ServerRegisterer {
    @NotNull
    private final BungeeServerRegistrationPlugin plugin;
    @NotNull
    private final List<Server> registered;

    public BungeeServerRegisterer(@NotNull BungeeServerRegistrationPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
        this.registered = new ArrayList();
    }

    @Override
    @NotNull
    public List<Server> getRegistered() {
        return this.registered;
    }

    @Override
    public void register(@NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        String id = this.plugin.getServerRegistration().parseServerId(server);
        ServerInfo info = ProxyServer.getInstance().constructServerInfo(id, InetSocketAddress.createUnresolved(server.getIp(), (int)server.getPort()), server.getUniqueId(), Boolean.parseBoolean(server.getProperties().getOrDefault("proxy-restricted", "false")));
        Map map2 = ProxyServer.getInstance().getServers();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getServers(...)");
        map2.put(id, info);
        this.registered.add(server);
    }

    @Override
    public void unregister(@NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        ProxyServer proxy = ProxyServer.getInstance();
        Map map2 = proxy.getServers();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getServers(...)");
        this.removeServer(map2, server.getUniqueId());
        this.registered.remove(server);
    }

    /*
     * WARNING - void declaration
     */
    private final ServerInfo removeServer(Map<String, ServerInfo> $this$removeServer, String uniqueId) {
        void $this$filterTo$iv$iv;
        Map<String, ServerInfo> $this$filter$iv = $this$removeServer;
        boolean $i$f$filter = false;
        Map<String, ServerInfo> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((ServerInfo)it.getValue()).getMotd(), (Object)uniqueId)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map toRemove = destination$iv$iv;
        ServerInfo serverInfo = (ServerInfo)CollectionsKt.firstOrNull((Iterable)toRemove.values());
        if (serverInfo == null) {
            return null;
        }
        ServerInfo value = serverInfo;
        String string = (String)CollectionsKt.firstOrNull((Iterable)toRemove.keySet());
        if (string == null) {
            return null;
        }
        String key = string;
        $this$removeServer.remove(key, value);
        return value;
    }
}

