/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize;

import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize.ScalarSerializer;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize.SerializationException;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.util.EnumLookup;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

final class EnumValueSerializer
extends ScalarSerializer<Enum<?>> {
    EnumValueSerializer() {
        super(new TypeToken<Enum<?>>(){});
    }

    @Override
    public Enum<?> deserialize(Type type, Object obj) throws SerializationException {
        String enumConstant = obj.toString();
        @Nullable Enum ret2 = EnumLookup.lookupEnum(GenericTypeReflector.erase(type).asSubclass(Enum.class), enumConstant);
        if (ret2 == null) {
            throw new SerializationException(type, "Invalid enum constant provided, expected a value of enum, got " + enumConstant);
        }
        return ret2;
    }

    @Override
    public Object serialize(Enum<?> item, Predicate<Class<?>> typeSupported) {
        return item.name();
    }
}

