/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize;

import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.ConfigurationNode;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize.SerializationException;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize.TypeSerializer;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ScalarSerializer<T>
implements TypeSerializer<T> {
    private final TypeToken<T> type;

    protected ScalarSerializer(TypeToken<T> type) {
        Type boxed = GenericTypeReflector.box(type.getType());
        this.type = boxed == type.getType() ? type : TypeToken.get(boxed);
    }

    protected ScalarSerializer(Class<T> type) {
        if (type.getTypeParameters().length > 0) {
            throw new IllegalArgumentException("Provided type " + type + " has type parameters but was not provided as a TypeToken!");
        }
        this.type = TypeToken.get(type);
    }

    ScalarSerializer(Type type) {
        this.type = TypeToken.get(type);
    }

    public final TypeToken<T> type() {
        return this.type;
    }

    @Override
    public final T deserialize(Type type, ConfigurationNode node) throws SerializationException {
        List<? extends ConfigurationNode> children;
        ConfigurationNode deserializeFrom = node;
        if (node.isList() && (children = node.childrenList()).size() == 1) {
            deserializeFrom = children.get(0);
        }
        if (deserializeFrom.isList() || deserializeFrom.isMap()) {
            throw new SerializationException(type, "Value must be provided as a scalar!");
        }
        @Nullable Object value = deserializeFrom.rawScalar();
        if (value == null) {
            throw new SerializationException(type, "No scalar value present");
        }
        type = GenericTypeReflector.box(type);
        @Nullable T possible = this.cast(value);
        if (possible != null) {
            return possible;
        }
        return this.deserialize(type, value);
    }

    public final T deserialize(Object value) throws SerializationException {
        @Nullable T possible = this.cast(value);
        if (possible != null) {
            return possible;
        }
        return this.deserialize(this.type().getType(), value);
    }

    public abstract T deserialize(Type var1, Object var2) throws SerializationException;

    @Override
    public final void serialize(Type type, @Nullable T obj, ConfigurationNode node) {
        if (obj == null) {
            node.raw(null);
            return;
        }
        if (node.options().acceptsType(obj.getClass())) {
            node.raw(obj);
            return;
        }
        node.raw(this.serialize(obj, node.options()::acceptsType));
    }

    protected abstract Object serialize(T var1, Predicate<Class<?>> var2);

    private @Nullable T cast(Object value) {
        Class<?> rawType = GenericTypeReflector.erase(this.type().getType());
        if (rawType.isInstance(value)) {
            return (T)value;
        }
        return null;
    }

    public final @Nullable T tryDeserialize(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return this.deserialize(obj);
        }
        catch (SerializationException ex) {
            return null;
        }
    }

    public final String serializeToString(T item) {
        if (item instanceof CharSequence) {
            return item.toString();
        }
        return (String)this.serialize(item, clazz -> clazz.isAssignableFrom(String.class));
    }
}

