/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize;

import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.ConfigurationNode;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.objectmapping.ConfigSerializable;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.objectmapping.ObjectMapper;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize.ArraySerializer;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize.ConfigurationNodeSerializer;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize.FileSerializer;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize.ListSerializer;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize.MapSerializer;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize.PathSerializer;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize.ScalarSerializer;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize.Scalars;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize.SerializationException;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize.SetSerializer;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.serialize.TypeSerializer;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.util.Types;
import app.simplecloud.plugin.registration.relocate.spongepowered.configurate.util.UnmodifiableCollections;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TypeSerializerCollection {
    private static final TypeSerializerCollection DEFAULTS = TypeSerializerCollection.builder().registerExact(Scalars.STRING).registerExact(Scalars.BOOLEAN).register(MapSerializer.TYPE, new MapSerializer()).register(ListSerializer.TYPE, new ListSerializer()).registerExact(Scalars.BYTE).registerExact(Scalars.SHORT).registerExact(Scalars.INTEGER).registerExact(Scalars.LONG).registerExact(Scalars.FLOAT).registerExact(Scalars.DOUBLE).registerAnnotatedObjects(ObjectMapper.factory()).register(Scalars.ENUM).registerExact(Scalars.CHAR).registerExact(Scalars.URI).registerExact(Scalars.URL).registerExact(Scalars.UUID).registerExact(Scalars.PATTERN).register(ArraySerializer.Objects::accepts, new ArraySerializer.Objects()).registerExact(ArraySerializer.Booleans.TYPE, new ArraySerializer.Booleans()).registerExact(ArraySerializer.Bytes.TYPE, new ArraySerializer.Bytes()).registerExact(ArraySerializer.Chars.TYPE, new ArraySerializer.Chars()).registerExact(ArraySerializer.Shorts.TYPE, new ArraySerializer.Shorts()).registerExact(ArraySerializer.Ints.TYPE, new ArraySerializer.Ints()).registerExact(ArraySerializer.Longs.TYPE, new ArraySerializer.Longs()).registerExact(ArraySerializer.Floats.TYPE, new ArraySerializer.Floats()).registerExact(ArraySerializer.Doubles.TYPE, new ArraySerializer.Doubles()).register(SetSerializer::accepts, new SetSerializer()).register(ConfigurationNodeSerializer.TYPE, new ConfigurationNodeSerializer()).register(PathSerializer.TYPE, PathSerializer.INSTANCE).registerExact(FileSerializer.TYPE, FileSerializer.INSTANCE).build();
    private final @Nullable TypeSerializerCollection parent;
    final List<RegisteredSerializer> serializers;
    private final Map<Type, TypeSerializer<?>> typeMatches = new ConcurrentHashMap();

    private TypeSerializerCollection(@Nullable TypeSerializerCollection parent, List<RegisteredSerializer> serializers) {
        this.parent = parent;
        this.serializers = UnmodifiableCollections.copyOf(serializers);
    }

    public <T> @Nullable TypeSerializer<T> get(TypeToken<T> token) {
        Objects.requireNonNull(token, "type");
        return this.get0(token.getType());
    }

    public <T> @Nullable TypeSerializer<T> get(Class<T> token) {
        Objects.requireNonNull(token, "type");
        Types.requireCompleteParameters(token);
        return this.get((Type)token);
    }

    public @Nullable TypeSerializer<?> get(Type type) {
        return this.get0(GenericTypeReflector.box(type));
    }

    private @Nullable TypeSerializer<?> get0(Type canonical) {
        @Nullable TypeSerializer<?> serial = this.typeMatches.computeIfAbsent(canonical, param -> {
            for (RegisteredSerializer ent : this.serializers) {
                if (!ent.predicate.test((Type)param)) continue;
                return ent.serializer;
            }
            return NoOp.INSTANCE;
        });
        if (serial == NoOp.INSTANCE) {
            serial = null;
        }
        if (serial == null && this.parent != null) {
            serial = this.parent.get0(canonical);
        }
        return serial;
    }

    public Builder childBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return "TypeSerializerCollection{parent=" + this.parent + ", serializers=" + this.serializers + '}';
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypeSerializerCollection)) {
            return false;
        }
        TypeSerializerCollection that = (TypeSerializerCollection)other;
        return Objects.equals(this.parent, that.parent) && this.serializers.equals(that.serializers);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.serializers);
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public static TypeSerializerCollection defaults() {
        return DEFAULTS;
    }

    static final class NoOp
    implements TypeSerializer<Void> {
        static final NoOp INSTANCE = new NoOp();

        private NoOp() {
        }

        @Override
        public Void deserialize(Type type, ConfigurationNode node) throws SerializationException {
            throw new UnsupportedOperationException("this is a placeholder for null, should not be called directly");
        }

        @Override
        public void serialize(Type type, @Nullable Void obj, ConfigurationNode node) throws SerializationException {
            throw new UnsupportedOperationException("this is a placeholder for null, should not be called directly");
        }
    }

    static final class RegisteredSerializer {
        final Predicate<Type> predicate;
        final TypeSerializer<?> serializer;

        private RegisteredSerializer(Predicate<Type> predicate, TypeSerializer<?> serializer) {
            this.predicate = predicate;
            this.serializer = serializer;
        }
    }

    public static class Builder {
        private final @Nullable TypeSerializerCollection parent;
        private final List<RegisteredSerializer> serializers = new ArrayList<RegisteredSerializer>();

        Builder(@Nullable TypeSerializerCollection parent) {
            this.parent = parent;
        }

        public <T> Builder register(TypeToken<T> type, TypeSerializer<? super T> serializer) {
            return this.register0(type.getType(), serializer);
        }

        public <T> Builder register(Class<T> type, TypeSerializer<? super T> serializer) {
            return this.register0(type, serializer);
        }

        public <T> Builder register(Predicate<Type> test, TypeSerializer<? super T> serializer) {
            Objects.requireNonNull(test, "test");
            Objects.requireNonNull(serializer, "serializer");
            this.serializers.add(new RegisteredSerializer(test, serializer));
            return this;
        }

        public <T> Builder register(ScalarSerializer<T> serializer) {
            Objects.requireNonNull(serializer, "serializer");
            return this.register(serializer.type(), serializer);
        }

        private Builder register0(Type type, TypeSerializer<?> serializer) {
            Objects.requireNonNull(type, "type");
            Objects.requireNonNull(serializer, "serializer");
            this.serializers.add(new RegisteredSerializer(test -> {
                Type[] upperBounds;
                if (GenericTypeReflector.isSuperType(type, test)) {
                    return true;
                }
                if (test instanceof WildcardType && (upperBounds = ((WildcardType)test).getUpperBounds()).length == 1) {
                    return GenericTypeReflector.isSuperType(type, upperBounds[0]);
                }
                return false;
            }, serializer));
            return this;
        }

        public <T> Builder registerExact(TypeToken<T> type, TypeSerializer<? super T> serializer) {
            return this.registerExact0(type.getType(), serializer);
        }

        public <T> Builder registerExact(Class<T> type, TypeSerializer<? super T> serializer) {
            return this.registerExact0(type, serializer);
        }

        public <T> Builder registerExact(ScalarSerializer<T> serializer) {
            Objects.requireNonNull(serializer, "serializer");
            return this.registerExact(serializer.type(), serializer);
        }

        private Builder registerExact0(Type type, TypeSerializer<?> serializer) {
            Objects.requireNonNull(type, "type");
            Objects.requireNonNull(serializer, "serializer");
            this.serializers.add(new RegisteredSerializer(test -> test.equals(type), serializer));
            return this;
        }

        public Builder registerAll(TypeSerializerCollection other) {
            this.serializers.addAll(Objects.requireNonNull(other, (String)"other").serializers);
            return this;
        }

        public Builder registerAnnotatedObjects(ObjectMapper.Factory factory) {
            return this.register(Builder::isAnnotatedTarget, factory.asTypeSerializer());
        }

        static boolean isAnnotatedTarget(Type type) {
            return GenericTypeReflector.annotate(type).isAnnotationPresent(ConfigSerializable.class);
        }

        public TypeSerializerCollection build() {
            return new TypeSerializerCollection(this.parent, this.serializers);
        }
    }
}

