/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.shadow.gson;

import dev.xhyrom.lanprops.shadow.gson.JsonElement;
import dev.xhyrom.lanprops.shadow.gson.JsonIOException;
import dev.xhyrom.lanprops.shadow.gson.JsonParseException;
import dev.xhyrom.lanprops.shadow.gson.JsonSyntaxException;
import dev.xhyrom.lanprops.shadow.gson.Strictness;
import dev.xhyrom.lanprops.shadow.gson.internal.Streams;
import dev.xhyrom.lanprops.shadow.gson.stream.JsonReader;
import dev.xhyrom.lanprops.shadow.gson.stream.JsonToken;
import dev.xhyrom.lanprops.shadow.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class JsonStreamParser
implements Iterator<JsonElement> {
    private final JsonReader parser;
    private final Object lock;

    public JsonStreamParser(String json) {
        this(new StringReader(json));
    }

    public JsonStreamParser(Reader reader) {
        this.parser = new JsonReader(reader);
        this.parser.setStrictness(Strictness.LENIENT);
        this.lock = new Object();
    }

    @Override
    public JsonElement next() throws JsonParseException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return Streams.parse(this.parser);
        }
        catch (OutOfMemoryError | StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source to Json", e);
        }
    }

    @Override
    public boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            try {
                return this.parser.peek() != JsonToken.END_DOCUMENT;
            }
            catch (MalformedJsonException e) {
                throw new JsonSyntaxException(e);
            }
            catch (IOException e) {
                throw new JsonIOException(e);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

