/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.shadow.tinylog.path;

import dev.xhyrom.lanprops.shadow.tinylog.Level;
import dev.xhyrom.lanprops.shadow.tinylog.provider.InternalLogger;
import java.io.File;

public final class FileTuple {
    private final File original;
    private final File backup;

    public FileTuple(File original, File backup) {
        this.original = original;
        this.backup = backup;
    }

    public File getOriginal() {
        return this.original;
    }

    public File getBackup() {
        return this.backup;
    }

    public long getLastModified() {
        return Math.max(this.original.lastModified(), this.backup.lastModified());
    }

    public void delete() {
        if (this.original.isFile() && !this.original.delete()) {
            InternalLogger.log(Level.WARN, "Failed to delete log file '" + this.original + "'");
        }
        if (!this.backup.equals(this.original) && this.backup.isFile() && !this.backup.delete()) {
            InternalLogger.log(Level.WARN, "Failed to delete backup file '" + this.backup + "'");
        }
    }
}

