/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.shadow.tinylog.pattern;

import dev.xhyrom.lanprops.shadow.tinylog.core.LogEntry;
import dev.xhyrom.lanprops.shadow.tinylog.core.LogEntryValue;
import dev.xhyrom.lanprops.shadow.tinylog.pattern.Token;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;

final class LineNumberToken
implements Token {
    LineNumberToken() {
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singleton(LogEntryValue.LINE);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        int line = logEntry.getLineNumber();
        if (line >= 0) {
            builder.append(line);
        } else {
            builder.append("?");
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        int line = logEntry.getLineNumber();
        if (line >= 0) {
            statement.setInt(index, line);
        } else {
            statement.setNull(index, 4);
        }
    }
}

