/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.shadow.tinylog.runtime;

import dev.xhyrom.lanprops.shadow.tinylog.runtime.Timestamp;
import dev.xhyrom.lanprops.shadow.tinylog.runtime.TimestampFormatter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class LegacyTimestampFormatter
implements TimestampFormatter {
    private static final int MILLISECOND_PRECISION = 1;
    private static final int SECOND_PRECISION = 1000;
    private static final int MINUTE_PRECISION = 60000;
    private final DateFormat formatter;
    private final long divisor;
    private Date lastDate;
    private String lastFormat;

    public LegacyTimestampFormatter(String pattern, Locale locale) {
        this.formatter = new SimpleDateFormat(pattern, locale);
        this.divisor = pattern.contains("S") ? 1L : (pattern.contains("s") ? 1000L : 60000L);
    }

    @Override
    public boolean isValid(String timestamp) {
        try {
            this.parse(timestamp);
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    @Override
    public String format(Timestamp timestamp) {
        return this.format(timestamp.toDate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String format(Date date) {
        DateFormat dateFormat = this.formatter;
        synchronized (dateFormat) {
            if (this.lastDate == null || date.getTime() / this.divisor != this.lastDate.getTime() / this.divisor) {
                this.lastDate = date;
                this.lastFormat = this.formatter.format(date);
            }
            return this.lastFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date parse(String timestamp) throws ParseException {
        DateFormat dateFormat = this.formatter;
        synchronized (dateFormat) {
            return this.formatter.parse(timestamp);
        }
    }
}

