/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.common.screens;

import com.google.common.collect.ImmutableList;
import dev.xhyrom.lanprops.common.LanPropertiesClient;
import dev.xhyrom.lanprops.common.accessors.CustomDedicatedServerProperties;
import dev.xhyrom.lanprops.common.accessors.CustomSettings;
import dev.xhyrom.lanprops.common.screens.PropertiesScreen;
import dev.xhyrom.lanprops.common.utils.StringUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameType;
import org.jetbrains.annotations.NotNull;

public class PropertiesList
extends ContainerObjectSelectionList<Entry> {
    private final DedicatedServerProperties serverProperties;

    public PropertiesList(PropertiesScreen screen, Minecraft minecraft, DedicatedServerProperties serverProperties) {
        super(minecraft, screen.width, screen.layout.getContentHeight(), screen.layout.getHeaderHeight(), 25);
        this.serverProperties = serverProperties;
        this.populateList();
    }

    private void populateList() {
        record PropertyData(String name, Class<?> type) {
        }
        ((CustomSettings)this.serverProperties).lan_properties$keys().entrySet().stream().map(entry -> new PropertyData((String)entry.getKey(), (Class)entry.getValue())).sorted(Comparator.comparing(PropertyData::name)).forEach(data -> {
            try {
                this.addEntry((AbstractSelectionList.Entry)new PropertyEntry(data.name(), data.type()));
            }
            catch (IllegalAccessException e) {
                LanPropertiesClient.LOGGER.error("Failed to create property entry for '{}'", data.name(), e);
            }
        });
    }

    public int getRowWidth() {
        return 360;
    }

    public class PropertyEntry
    extends Entry {
        private final Component propertyName;
        private final AbstractWidget editWidget;
        private static final int PADDING = 160;

        public PropertyEntry(String propertyKey, Class<?> type) throws IllegalAccessException {
            this.propertyName = Component.literal((String)StringUtils.kebabCaseToTitleCase(propertyKey));
            Properties properties = ((CustomDedicatedServerProperties)PropertiesList.this.serverProperties).lan_properties$properties();
            String currentValue = (String)properties.get(propertyKey);
            this.editWidget = this.createWidget(type, currentValue, (raw, serialized) -> {
                properties.put(propertyKey, serialized);
                LanPropertiesClient.LOGGER.info("Updated property '{}' to '{}'", propertyKey, serialized);
            });
        }

        private AbstractWidget createWidget(Class<?> type, String value, BiConsumer<Object, String> callback) {
            if (type == Boolean.TYPE) {
                return CycleButton.onOffBuilder().withInitialValue((Object)Boolean.parseBoolean(value)).displayOnlyValue().create(0, 0, 150, 20, (Component)Component.empty(), (btn, val) -> callback.accept(val, val.toString()));
            }
            if (type == Integer.TYPE) {
                EditBox editBox = new EditBox(((PropertiesList)PropertiesList.this).minecraft.font, 0, 0, 148, 18, (Component)Component.empty());
                editBox.setValue(value);
                editBox.setResponder(str -> {
                    if (str.matches("-?\\d+")) {
                        callback.accept(Integer.parseInt(str), (String)str);
                        editBox.setTextColor(-2039584);
                    } else {
                        editBox.setTextColor(-236718492);
                    }
                });
                return editBox;
            }
            if (type == Long.TYPE) {
                EditBox editBox = new EditBox(((PropertiesList)PropertiesList.this).minecraft.font, 0, 0, 148, 18, (Component)Component.empty());
                editBox.setValue(value);
                editBox.setResponder(str -> {
                    if (str.matches("-?\\d+")) {
                        callback.accept(Long.parseLong(str), (String)str);
                        editBox.setTextColor(-2039584);
                    } else {
                        editBox.setTextColor(-236718492);
                    }
                });
                return editBox;
            }
            if (type.isEnum()) {
                if (type == Difficulty.class) {
                    return CycleButton.builder(Difficulty::getDisplayName).withValues((Object[])Difficulty.values()).withInitialValue((Object)Difficulty.byName((String)value)).displayOnlyValue().create(0, 0, 150, 20, (Component)Component.empty(), (btn, val) -> callback.accept(val, val.getSerializedName()));
                }
                if (type == GameType.class) {
                    return CycleButton.builder(GameType::getShortDisplayName).withValues((Object[])GameType.values()).withInitialValue((Object)GameType.byName((String)value)).displayOnlyValue().create(0, 0, 150, 20, (Component)Component.empty(), (btn, val) -> callback.accept(val, val.getName()));
                }
            }
            EditBox editBox = new EditBox(((PropertiesList)PropertiesList.this).minecraft.font, 0, 0, 148, 18, (Component)Component.empty());
            if (value != null) {
                editBox.setValue(value);
            }
            editBox.setResponder(str -> callback.accept(str, (String)str));
            return editBox;
        }

        public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTick) {
            guiGraphics.drawString(((PropertiesList)PropertiesList.this).minecraft.font, this.propertyName, left, top + height / 2 - 4, -1);
            this.editWidget.setX(left + 160);
            this.editWidget.setY(top);
            this.editWidget.render(guiGraphics, mouseX, mouseY, partialTick);
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.editWidget);
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.editWidget);
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

