/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.common.screens;

import dev.xhyrom.lanprops.common.accessors.CustomIntegratedServer;
import dev.xhyrom.lanprops.common.screens.PropertiesList;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import org.jetbrains.annotations.Nullable;

public class PropertiesScreen
extends Screen {
    private static final Component TITLE = Component.translatable((String)"lan_properties.gui.properties");
    @Nullable
    private final Screen lastScreen;
    private DedicatedServerSettings serverSettings;
    public final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private PropertiesList propertiesList;

    public PropertiesScreen(@Nullable Screen screen) {
        super(TITLE);
        this.lastScreen = screen;
    }

    protected void init() {
        CustomIntegratedServer server = (CustomIntegratedServer)this.minecraft.getSingleplayerServer();
        this.serverSettings = server.lan_properties$settings();
        this.layout.addTitleHeader(TITLE, this.font);
        this.propertiesList = (PropertiesList)this.layout.addToContents((LayoutElement)new PropertiesList(this, this.minecraft, this.serverSettings.getProperties()));
        LinearLayout footerLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        footerLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"lan_properties.gui.open_world"), button -> Util.getPlatform().openPath(server.lan_properties$propertiesPath().getParent())).build());
        footerLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.propertiesList != null) {
            this.propertiesList.updateSize(this.width, this.layout);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.propertiesList.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void onClose() {
        this.serverSettings.forceSave();
        this.minecraft.setScreen(this.lastScreen);
    }
}

