/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.shadow.tinylog.pattern;

import dev.xhyrom.lanprops.shadow.tinylog.core.LogEntry;
import dev.xhyrom.lanprops.shadow.tinylog.core.LogEntryValue;
import dev.xhyrom.lanprops.shadow.tinylog.pattern.Token;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;

class SizeToken
implements Token {
    private final Token token;
    private final int size;

    SizeToken(Token token, int size) {
        this.token = token;
        this.size = size;
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return this.token.getRequiredLogEntryValues();
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        int offset = builder.length();
        this.token.render(logEntry, builder);
        int size = builder.length() - offset;
        if (size > this.size) {
            builder.delete(offset, offset + size - this.size);
        }
        if (size < this.size) {
            for (int i = 0; i < this.size - size; ++i) {
                builder.append(' ');
            }
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        StringBuilder builder = new StringBuilder();
        this.render(logEntry, builder);
        statement.setString(index, builder.toString());
    }
}

