/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.shadow.tinylog.policies;

import dev.xhyrom.lanprops.shadow.tinylog.policies.Policy;
import java.io.File;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractDatePolicy
implements Policy {
    private static final Pattern TIME_PATTERN = Pattern.compile("^([01]?[0-9]|2[0-3])([^\\d]+([0-5]?[0-9]))?(@(.+))?$");
    private static final int GROUP_HOUR = 1;
    private static final int GROUP_MINUTE = 3;
    private static final int GROUP_ZONE = 5;
    private final Calendar calendar;

    protected AbstractDatePolicy(String name, String argument) {
        if (argument == null || argument.isEmpty()) {
            this.calendar = Calendar.getInstance();
            this.truncate(this.calendar, 0, 0);
        } else {
            Matcher matcher = TIME_PATTERN.matcher(argument);
            if (matcher.matches()) {
                TimeZone timeZone;
                String hour = matcher.group(1);
                String minute = matcher.group(3);
                String zoneId = matcher.group(5);
                TimeZone timeZone2 = timeZone = zoneId == null ? null : TimeZone.getTimeZone(zoneId);
                if (timeZone == null) {
                    this.calendar = Calendar.getInstance();
                } else {
                    if (!timeZone.getID().equals(zoneId)) {
                        throw new IllegalArgumentException("Invalid time zone \"" + zoneId + "\" for " + name);
                    }
                    this.calendar = Calendar.getInstance(timeZone);
                }
                this.truncate(this.calendar, Integer.parseInt(hour), minute == null ? 0 : Integer.parseInt(minute));
            } else {
                throw new IllegalArgumentException("Invalid time for " + name + ": " + argument);
            }
        }
        this.reset();
    }

    @Override
    public final boolean continueExistingFile(String path) {
        Calendar clone = (Calendar)this.calendar.clone();
        this.scrollBack(clone);
        return clone.getTimeInMillis() <= new File(path).lastModified();
    }

    @Override
    public final boolean continueCurrentFile(byte[] entry) {
        return this.calendar.getTimeInMillis() > System.currentTimeMillis();
    }

    @Override
    public final void reset() {
        while (this.calendar.getTimeInMillis() <= System.currentTimeMillis()) {
            this.scrollAhead(this.calendar);
        }
    }

    protected abstract void truncate(Calendar var1, int var2, int var3);

    protected abstract void scrollBack(Calendar var1);

    protected abstract void scrollAhead(Calendar var1);
}

