/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.shadow.tinylog.runtime;

import dev.xhyrom.lanprops.shadow.tinylog.runtime.Timestamp;
import dev.xhyrom.lanprops.shadow.tinylog.runtime.TimestampFormatter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Locale;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@IgnoreJRERequirement
public final class PreciseTimestampFormatter
implements TimestampFormatter {
    private final DateTimeFormatter formatter;
    private final TemporalUnit truncationUnit;
    private Instant minInstant;
    private Instant maxInstant;
    private String lastFormat;

    public PreciseTimestampFormatter(String pattern, Locale locale) {
        this.formatter = DateTimeFormatter.ofPattern(pattern, locale).withZone(ZoneId.systemDefault());
        this.truncationUnit = pattern.contains("n") || pattern.contains("N") || pattern.contains("SSSS") ? null : (pattern.contains("S") ? ChronoUnit.MILLIS : (pattern.contains("s") ? ChronoUnit.SECONDS : ChronoUnit.MINUTES));
        this.minInstant = Instant.MAX;
        this.maxInstant = Instant.MIN;
    }

    @Override
    public boolean isValid(String timestamp) {
        try {
            this.formatter.parse(timestamp);
            return true;
        }
        catch (DateTimeParseException ex) {
            return false;
        }
    }

    @Override
    public String format(Timestamp timestamp) {
        Instant instant = timestamp.toInstant();
        return this.truncationUnit == null ? this.formatter.format(instant) : this.format(instant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String format(Instant instant) {
        DateTimeFormatter dateTimeFormatter = this.formatter;
        synchronized (dateTimeFormatter) {
            if (!instant.isBefore(this.maxInstant) || instant.isBefore(this.minInstant)) {
                this.minInstant = instant.truncatedTo(this.truncationUnit);
                this.maxInstant = this.minInstant.plus(1L, this.truncationUnit);
                this.lastFormat = this.formatter.format(instant);
            }
            return this.lastFormat;
        }
    }
}

