/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.shadow.tinylog.writers;

import dev.xhyrom.lanprops.shadow.tinylog.core.LogEntry;
import dev.xhyrom.lanprops.shadow.tinylog.core.LogEntryValue;
import dev.xhyrom.lanprops.shadow.tinylog.pattern.FormatPatternParser;
import dev.xhyrom.lanprops.shadow.tinylog.pattern.Token;
import dev.xhyrom.lanprops.shadow.tinylog.writers.AbstractFileBasedWriter;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractFormatPatternWriter
extends AbstractFileBasedWriter {
    private static final String DEFAULT_FORMAT_PATTERN = "{date} [{thread}] {class}.{method}()\n{level}: {message}";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final int BUILDER_CAPACITY = 1024;
    private final StringBuilder builder;
    private final Token token;

    public AbstractFormatPatternWriter(Map<String, String> properties) {
        super(properties);
        String pattern = this.getStringValue("format");
        if (pattern == null) {
            pattern = DEFAULT_FORMAT_PATTERN;
        }
        this.token = new FormatPatternParser(this.getStringValue("exception")).parse(pattern + NEW_LINE);
        this.builder = this.getBooleanValue("writingthread") ? new StringBuilder(1024) : null;
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return this.token.getRequiredLogEntryValues();
    }

    protected final String render(LogEntry logEntry) {
        if (this.builder == null) {
            StringBuilder builder = new StringBuilder(1024);
            this.token.render(logEntry, builder);
            return builder.toString();
        }
        this.builder.setLength(0);
        this.token.render(logEntry, this.builder);
        return this.builder.toString();
    }
}

