/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.shadow.tinylog.writers;

import android.util.Log;
import dev.xhyrom.lanprops.shadow.tinylog.Level;
import dev.xhyrom.lanprops.shadow.tinylog.core.LogEntry;
import dev.xhyrom.lanprops.shadow.tinylog.core.LogEntryValue;
import dev.xhyrom.lanprops.shadow.tinylog.pattern.FormatPatternParser;
import dev.xhyrom.lanprops.shadow.tinylog.pattern.Token;
import dev.xhyrom.lanprops.shadow.tinylog.provider.InternalLogger;
import dev.xhyrom.lanprops.shadow.tinylog.writers.AbstractWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;

public final class LogcatWriter
extends AbstractWriter {
    private static final String DEFAULT_TAG_FORMAT_PATTERN = "{class-name}";
    private static final String DEFAULT_MESSAGE_FORMAT_PATTERN = "{message}";
    private static final String ELLIPSIS = "...";
    private static final int TAG_MAX_LENGTH = 23;
    private static final int MESSAGE_BUILDER_CAPACITY = 1024;
    private final StringBuilder tagBuilder;
    private final Token tagToken;
    private final StringBuilder messageBuilder;
    private final Token messageToken;

    public LogcatWriter() {
        this(Collections.emptyMap());
    }

    public LogcatWriter(Map<String, String> properties) {
        super(properties);
        FormatPatternParser parser = new FormatPatternParser(this.getStringValue("exception"));
        boolean hasWritingThread = this.getBooleanValue("writingthread");
        String tagPattern = this.getStringValue("tagname");
        if (tagPattern == null) {
            tagPattern = DEFAULT_TAG_FORMAT_PATTERN;
        }
        this.tagToken = parser.parse(tagPattern);
        this.tagBuilder = hasWritingThread ? new StringBuilder(23) : null;
        String messagePattern = properties.get("format");
        if (messagePattern == null) {
            messagePattern = DEFAULT_MESSAGE_FORMAT_PATTERN;
        }
        this.messageToken = parser.parse(messagePattern);
        this.messageBuilder = hasWritingThread ? new StringBuilder(1024) : null;
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        EnumSet<LogEntryValue> values = EnumSet.of(LogEntryValue.LEVEL);
        values.addAll(this.tagToken.getRequiredLogEntryValues());
        values.addAll(this.messageToken.getRequiredLogEntryValues());
        return values;
    }

    @Override
    public void write(LogEntry logEntry) {
        String tag = this.renderTag(logEntry);
        String message = this.renderMessage(logEntry);
        switch (logEntry.getLevel()) {
            case TRACE: {
                Log.println((int)2, (String)tag, (String)message);
                break;
            }
            case DEBUG: {
                Log.println((int)3, (String)tag, (String)message);
                break;
            }
            case INFO: {
                Log.println((int)4, (String)tag, (String)message);
                break;
            }
            case WARN: {
                Log.println((int)5, (String)tag, (String)message);
                break;
            }
            case ERROR: {
                Log.println((int)6, (String)tag, (String)message);
                break;
            }
            default: {
                InternalLogger.log(Level.ERROR, "Unexpected logging level: " + (Object)((Object)logEntry.getLevel()));
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private String renderTag(LogEntry logEntry) {
        StringBuilder builder = LogcatWriter.reuseOrCreate(this.tagBuilder, 23);
        this.tagToken.render(logEntry, builder);
        if (builder.length() > 23) {
            return builder.substring(0, 23 - ELLIPSIS.length()) + ELLIPSIS;
        }
        return builder.toString();
    }

    private String renderMessage(LogEntry logEntry) {
        StringBuilder builder = LogcatWriter.reuseOrCreate(this.messageBuilder, 1024);
        this.messageToken.render(logEntry, builder);
        return builder.toString();
    }

    private static StringBuilder reuseOrCreate(StringBuilder builder, int capacity) {
        if (builder == null) {
            return new StringBuilder(capacity);
        }
        builder.setLength(0);
        return builder;
    }
}

