/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.common.screens;

import com.google.common.collect.ImmutableList;
import dev.xhyrom.lanprops.common.LanPropertiesClient;
import dev.xhyrom.lanprops.common.accessors.CustomDedicatedServerProperties;
import dev.xhyrom.lanprops.common.accessors.CustomSettings;
import dev.xhyrom.lanprops.common.screens.PropertiesScreen;
import dev.xhyrom.lanprops.common.utils.StringUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import net.minecraft.class_1267;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_3806;
import net.minecraft.class_4265;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import org.jetbrains.annotations.NotNull;

public class PropertiesList
extends class_4265<Entry> {
    private final class_3806 serverProperties;

    public PropertiesList(PropertiesScreen screen, class_310 minecraft, class_3806 serverProperties) {
        super(minecraft, screen.field_22789, screen.layout.method_57727(), screen.layout.method_48998(), 25);
        this.serverProperties = serverProperties;
        this.populateList();
    }

    private void populateList() {
        record PropertyData(String name, Class<?> type) {
        }
        ((CustomSettings)this.serverProperties).lan_properties$keys().entrySet().stream().map(entry -> new PropertyData((String)entry.getKey(), (Class)entry.getValue())).sorted(Comparator.comparing(PropertyData::name)).forEach(data -> {
            try {
                this.method_25321((class_350.class_351)new PropertyEntry(data.name(), data.type()));
            }
            catch (IllegalAccessException e) {
                LanPropertiesClient.LOGGER.error("Failed to create property entry for '{}'", data.name(), e);
            }
        });
    }

    public int method_25322() {
        return 360;
    }

    public class PropertyEntry
    extends Entry {
        private final class_2561 propertyName;
        private final class_339 editWidget;
        private static final int PADDING = 160;

        public PropertyEntry(String propertyKey, Class<?> type) throws IllegalAccessException {
            this.propertyName = class_2561.method_43470((String)StringUtils.kebabCaseToTitleCase(propertyKey));
            Properties properties = ((CustomDedicatedServerProperties)PropertiesList.this.serverProperties).lan_properties$properties();
            String currentValue = (String)properties.get(propertyKey);
            this.editWidget = this.createWidget(type, currentValue, (raw, serialized) -> {
                properties.put(propertyKey, serialized);
                LanPropertiesClient.LOGGER.info("Updated property '{}' to '{}'", propertyKey, serialized);
            });
        }

        private class_339 createWidget(Class<?> type, String value, BiConsumer<Object, String> callback) {
            if (type == Boolean.TYPE) {
                return class_5676.method_32614().method_32619((Object)Boolean.parseBoolean(value)).method_32616().method_32617(0, 0, 150, 20, (class_2561)class_2561.method_43473(), (btn, val) -> callback.accept(val, val.toString()));
            }
            if (type == Integer.TYPE) {
                class_342 editBox = new class_342(((PropertiesList)PropertiesList.this).field_22740.field_1772, 0, 0, 148, 18, (class_2561)class_2561.method_43473());
                editBox.method_1852(value);
                editBox.method_1863(str -> {
                    if (str.matches("-?\\d+")) {
                        callback.accept(Integer.parseInt(str), (String)str);
                        editBox.method_1868(-2039584);
                    } else {
                        editBox.method_1868(-236718492);
                    }
                });
                return editBox;
            }
            if (type == Long.TYPE) {
                class_342 editBox = new class_342(((PropertiesList)PropertiesList.this).field_22740.field_1772, 0, 0, 148, 18, (class_2561)class_2561.method_43473());
                editBox.method_1852(value);
                editBox.method_1863(str -> {
                    if (str.matches("-?\\d+")) {
                        callback.accept(Long.parseLong(str), (String)str);
                        editBox.method_1868(-2039584);
                    } else {
                        editBox.method_1868(-236718492);
                    }
                });
                return editBox;
            }
            if (type.isEnum()) {
                if (type == class_1267.class) {
                    return class_5676.method_32606(class_1267::method_5463).method_32624((Object[])class_1267.values()).method_32619((Object)class_1267.method_16691((String)value)).method_32616().method_32617(0, 0, 150, 20, (class_2561)class_2561.method_43473(), (btn, val) -> callback.accept(val, val.method_15434()));
                }
                if (type == class_1934.class) {
                    return class_5676.method_32606(class_1934::method_32763).method_32624((Object[])class_1934.values()).method_32619((Object)class_1934.method_8385((String)value)).method_32616().method_32617(0, 0, 150, 20, (class_2561)class_2561.method_43473(), (btn, val) -> callback.accept(val, val.method_8381()));
                }
            }
            class_342 editBox = new class_342(((PropertiesList)PropertiesList.this).field_22740.field_1772, 0, 0, 148, 18, (class_2561)class_2561.method_43473());
            if (value != null) {
                editBox.method_1852(value);
            }
            editBox.method_1863(str -> callback.accept(str, (String)str));
            return editBox;
        }

        public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTick) {
            guiGraphics.method_27535(((PropertiesList)PropertiesList.this).field_22740.field_1772, this.propertyName, left, top + height / 2 - 4, -1);
            this.editWidget.method_46421(left + 160);
            this.editWidget.method_46419(top);
            this.editWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.editWidget);
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.editWidget);
        }
    }

    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
    }
}

