/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.shadow.gson.internal.bind;

import dev.xhyrom.lanprops.shadow.gson.Gson;
import dev.xhyrom.lanprops.shadow.gson.JsonSyntaxException;
import dev.xhyrom.lanprops.shadow.gson.ToNumberPolicy;
import dev.xhyrom.lanprops.shadow.gson.ToNumberStrategy;
import dev.xhyrom.lanprops.shadow.gson.TypeAdapter;
import dev.xhyrom.lanprops.shadow.gson.TypeAdapterFactory;
import dev.xhyrom.lanprops.shadow.gson.reflect.TypeToken;
import dev.xhyrom.lanprops.shadow.gson.stream.JsonReader;
import dev.xhyrom.lanprops.shadow.gson.stream.JsonToken;
import dev.xhyrom.lanprops.shadow.gson.stream.JsonWriter;
import java.io.IOException;

public final class NumberTypeAdapter
extends TypeAdapter<Number> {
    private static final TypeAdapterFactory LAZILY_PARSED_NUMBER_FACTORY = NumberTypeAdapter.newFactory(ToNumberPolicy.LAZILY_PARSED_NUMBER);
    private final ToNumberStrategy toNumberStrategy;

    private NumberTypeAdapter(ToNumberStrategy toNumberStrategy) {
        this.toNumberStrategy = toNumberStrategy;
    }

    private static TypeAdapterFactory newFactory(ToNumberStrategy toNumberStrategy) {
        final NumberTypeAdapter adapter = new NumberTypeAdapter(toNumberStrategy);
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                return type.getRawType() == Number.class ? adapter : null;
            }
        };
    }

    public static TypeAdapterFactory getFactory(ToNumberStrategy toNumberStrategy) {
        if (toNumberStrategy == ToNumberPolicy.LAZILY_PARSED_NUMBER) {
            return LAZILY_PARSED_NUMBER_FACTORY;
        }
        return NumberTypeAdapter.newFactory(toNumberStrategy);
    }

    @Override
    public Number read(JsonReader in) throws IOException {
        JsonToken jsonToken = in.peek();
        switch (jsonToken) {
            case NULL: {
                in.nextNull();
                return null;
            }
            case NUMBER: 
            case STRING: {
                return this.toNumberStrategy.readNumber(in);
            }
        }
        throw new JsonSyntaxException("Expecting number, got: " + (Object)((Object)jsonToken) + "; at path " + in.getPath());
    }

    @Override
    public void write(JsonWriter out, Number value) throws IOException {
        out.value(value);
    }
}

