/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.shadow.tinylog.core;

import dev.xhyrom.lanprops.shadow.tinylog.Level;
import dev.xhyrom.lanprops.shadow.tinylog.core.LogEntry;
import dev.xhyrom.lanprops.shadow.tinylog.provider.InternalLogger;
import dev.xhyrom.lanprops.shadow.tinylog.writers.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class WritingThread
extends Thread {
    private static final String THREAD_NAME = "tinylog-WritingThread";
    private final Object mutex = new Object();
    private final Collection<Writer> writers;
    private List<Task> tasks;

    WritingThread(Collection<Writer> writers) {
        this.writers = writers;
        this.tasks = new ArrayList<Task>();
        this.setName(THREAD_NAME);
        this.setPriority(1);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        ArrayList<Writer> writers = new ArrayList<Writer>(1);
        while (true) {
            for (Task task : this.receiveTasks()) {
                if (task == Task.POISON) {
                    this.close();
                    return;
                }
                this.write(writers, task);
            }
            this.flush(writers);
            writers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Writer writer, LogEntry logEntry) {
        Task task = new Task(writer, logEntry);
        Object object = this.mutex;
        synchronized (object) {
            this.tasks.add(task);
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.mutex;
        synchronized (object) {
            this.tasks.add(Task.POISON);
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Task> receiveTasks() {
        Object object = this.mutex;
        synchronized (object) {
            while (this.tasks.isEmpty()) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException ex) {
                    return Collections.emptyList();
                }
            }
            List<Task> currentTasks = this.tasks;
            this.tasks = new ArrayList<Task>();
            return currentTasks;
        }
    }

    private void write(Collection<Writer> writers, Task task) {
        try {
            Writer writer = task.writer;
            writer.write(task.logEntry);
            if (!writers.contains(writer)) {
                writers.add(writer);
            }
        }
        catch (Exception ex) {
            InternalLogger.log(Level.ERROR, ex, "Failed to write log entry '" + task.logEntry.getMessage() + "'");
        }
    }

    private void flush(Collection<Writer> writers) {
        for (Writer writer : writers) {
            try {
                writer.flush();
            }
            catch (Exception ex) {
                InternalLogger.log(Level.ERROR, ex, "Failed to flush writer");
            }
        }
    }

    private void close() {
        for (Writer writer : this.writers) {
            try {
                writer.close();
            }
            catch (Exception ex) {
                InternalLogger.log(Level.ERROR, ex, "Failed to close writer");
            }
        }
    }

    private static final class Task {
        private static final Task POISON = null;
        private final Writer writer;
        private final LogEntry logEntry;

        Task(Writer writer, LogEntry logEntry) {
            this.writer = writer;
            this.logEntry = logEntry;
        }
    }
}

