/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.shadow.tinylog.pattern;

import dev.xhyrom.lanprops.shadow.tinylog.core.LogEntry;
import dev.xhyrom.lanprops.shadow.tinylog.core.LogEntryValue;
import dev.xhyrom.lanprops.shadow.tinylog.pattern.Token;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;

final class SimpleClassNameToken
implements Token {
    SimpleClassNameToken() {
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singleton(LogEntryValue.CLASS);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        builder.append(SimpleClassNameToken.getSimpleClassName(logEntry.getClassName()));
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        statement.setString(index, SimpleClassNameToken.getSimpleClassName(logEntry.getClassName()));
    }

    private static String getSimpleClassName(String fullyQualifiedClassName) {
        if (fullyQualifiedClassName == null) {
            return null;
        }
        int dotIndex = fullyQualifiedClassName.lastIndexOf(46);
        if (dotIndex < 0) {
            return fullyQualifiedClassName;
        }
        return fullyQualifiedClassName.substring(dotIndex + 1);
    }
}

