/*
 * Decompiled with CFR 0.152.
 */
package dev.xhyrom.lanprops.shadow.tinylog.writers.raw;

import dev.xhyrom.lanprops.shadow.tinylog.writers.raw.ByteArrayWriter;
import java.io.IOException;
import java.util.Arrays;

public class CharsetAdjustmentWriterDecorator
implements ByteArrayWriter {
    private final ByteArrayWriter writer;
    private final byte[] charsetHeader;

    public CharsetAdjustmentWriterDecorator(ByteArrayWriter writer, byte[] charsetHeader) {
        this.writer = writer;
        this.charsetHeader = Arrays.copyOf(charsetHeader, charsetHeader.length);
    }

    @Override
    public int readTail(byte[] data, int offset, int length) throws IOException {
        return this.writer.readTail(data, offset, length);
    }

    @Override
    public void write(byte[] data, int length) throws IOException {
        this.write(data, 0, length);
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (this.startsWithCharsetHeader(data, offset, length)) {
            this.writer.write(data, offset + this.charsetHeader.length, length - this.charsetHeader.length);
        } else {
            this.writer.write(data, offset, length);
        }
    }

    @Override
    public void truncate(int count) throws IOException {
        this.writer.truncate(count);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private boolean startsWithCharsetHeader(byte[] data, int offset, int length) {
        if (this.charsetHeader.length > length) {
            return false;
        }
        for (int i = 0; i < this.charsetHeader.length; ++i) {
            if (this.charsetHeader[i] == data[offset + i]) continue;
            return false;
        }
        return true;
    }
}

