/*
 * Decompiled with CFR 0.152.
 */
package me.mightyknight.sd.multiversion_mixin;

import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import me.mightyknight.sd.common.ShieldDisruptor;
import me.mightyknight.sd.multiversion_mixin.ConditionalMixin;
import me.mightyknight.sd.multiversion_mixin.Platform;
import me.mightyknight.sd.multiversion_mixin.VersionedMixin;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class NeruinaMixinPlugin
implements IMixinConfigPlugin {
    public static boolean testClass(String className) {
        try {
            List annotationNodes = MixinService.getService().getBytecodeProvider().getClassNode((String)className).visibleAnnotations;
            if (annotationNodes == null) {
                return true;
            }
            boolean shouldApply = true;
            for (AnnotationNode node : annotationNodes) {
                if (node.desc.equals(Type.getDescriptor(ConditionalMixin.class))) {
                    List modids = (List)Annotations.getValue((AnnotationNode)node, (String)"modids");
                    boolean applyIfPresent = (Boolean)Annotations.getValue((AnnotationNode)node, (String)"applyIfPresent", (Object)Boolean.TRUE);
                    if (NeruinaMixinPlugin.anyModsLoaded(modids)) {
                        ShieldDisruptor.LOGGER.debug("NeruinaMixinPlugin: " + className + " is" + (applyIfPresent ? " " : " not ") + "being applied because " + String.valueOf(modids) + " are loaded");
                        shouldApply = applyIfPresent;
                    } else {
                        ShieldDisruptor.LOGGER.debug("NeruinaMixinPlugin: " + className + " is" + (!applyIfPresent ? " " : " not ") + "being applied because " + String.valueOf(modids) + " are not loaded");
                        shouldApply = !applyIfPresent;
                    }
                } else if (node.desc.equals(Type.getDescriptor(VersionedMixin.class))) {
                    String min = (String)Annotations.getValue((AnnotationNode)node, (String)"min", (Object)"");
                    String max = (String)Annotations.getValue((AnnotationNode)node, (String)"max", (Object)"");
                    String currentVersion = Platform.getMinecraftVersion();
                    ComparableVersion comparableVersion = new ComparableVersion(currentVersion);
                    shouldApply = NeruinaMixinPlugin.evaluateVersion(className, min, max, currentVersion, comparableVersion);
                }
                if (shouldApply) continue;
                break;
            }
            return shouldApply;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean evaluateVersion(String className, String min, String max, String currentVersion, ComparableVersion comparableVersion) {
        boolean shouldApply = true;
        if (!min.isBlank()) {
            shouldApply &= comparableVersion.compareTo(new ComparableVersion(min)) >= 0;
        }
        if (!max.isBlank()) {
            shouldApply &= comparableVersion.compareTo(new ComparableVersion(max)) <= 0;
        }
        ShieldDisruptor.LOGGER.debug(String.format("NeruinaMixinPlugin: %s is %sbeing applied because we are using %s is in range (%s, %s)", className, shouldApply ? "" : "not ", currentVersion, min, max));
        return shouldApply;
    }

    private static boolean anyModsLoaded(List<String> modids) {
        for (String modid : modids) {
            if (!Platform.isModLoaded(modid)) continue;
            return true;
        }
        return false;
    }

    public void onLoad(String mixinPackage) {
        MixinExtrasBootstrap.init();
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetName, String className) {
        return NeruinaMixinPlugin.testClass(className);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

