package net.adventurez.block;

import net.adventurez.init.BlockInit;
import net.adventurez.init.ConfigInit;
import net.minecraft.class_10;
import net.minecraft.class_1750;
import net.minecraft.class_1792.class_9635;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3726;
import net.minecraft.class_5558;
import java.util.List;
import org.jetbrains.annotations.Nullable;

import net.adventurez.block.entity.PiglinFlagEntity;

public class PiglinFlag extends class_2248 implements class_2343 {
    public static final class_2753 FACING;
    private static final class_265 BASE;
    private static final class_265 POLE;
    private static final class_265 BAR_1;
    private static final class_265 BAR_2;
    private static final class_265 BAR_3;
    private static final class_265 BAR_4;
    private static final class_265 NORTH_FLAG;
    private static final class_265 EAST_FLAG;
    private static final class_265 SOUTH_FLAG;
    private static final class_265 WEST_FLAG;

    public PiglinFlag(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PiglinFlagEntity(pos, state);
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return checkType(type, BlockInit.PIGLIN_FLAG_ENTITY, world.method_8608() ? PiglinFlagEntity::clientTick : PiglinFlagEntity::serverTick);
    }

    @Override
    public void method_9568(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        if (ConfigInit.CONFIG.allow_extra_tooltips) {
            tooltip.add(class_2561.method_43471("item.adventurez.moreinfo.tooltip"));
            if (class_3675.method_15987(class_310.method_1551().method_22683().method_4490(), 340)) {
                tooltip.remove(class_2561.method_43471("item.adventurez.moreinfo.tooltip"));
                tooltip.add(class_2561.method_43471("block.adventurez.piglin_flag.tooltip"));
                tooltip.add(class_2561.method_43471("block.adventurez.piglin_flag.tooltip2"));
                tooltip.add(class_2561.method_43471("block.adventurez.piglin_flag.tooltip3"));
            }
        }
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(FACING, ctx.method_8042().method_10170());
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.getShape(state);
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return BASE;
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    private class_265 getShape(class_2680 state) {
        class_2350 direction = state.method_11654(FACING);
        if (direction == class_2350.field_11043) {
            return NORTH_FLAG;
        } else if (direction == class_2350.field_11034) {
            return EAST_FLAG;
        } else if (direction == class_2350.field_11035) {
            return SOUTH_FLAG;
        } else if (direction == class_2350.field_11039) {
            return WEST_FLAG;
        } else {
            return NORTH_FLAG;
        }
    }

    @SuppressWarnings("unchecked")
    @Nullable
    private static <E extends class_2586, A extends class_2586> class_5558<A> checkType(class_2591<A> givenType, class_2591<E> expectedType, class_5558<? super E> ticker) {
        return expectedType == givenType ? (class_5558<A>) ticker : null;
    }

    static {
        FACING = class_2383.field_11177;
        BASE = method_9541(6D, 0D, 6D, 10D, 11D, 10D);
        POLE = class_259.method_1084(BASE, method_9541(7D, 11D, 7D, 9D, 40D, 9D));
        BAR_1 = class_2248.method_9541(6D, 40D, -8D, 10D, 44D, 10D);
        BAR_2 = class_2248.method_9541(6D, 40D, 6D, 24D, 44D, 10D);
        BAR_3 = class_2248.method_9541(6D, 40D, 6D, 10D, 44D, 24D);
        BAR_4 = class_2248.method_9541(-8D, 40D, 6D, 10D, 44D, 10D);
        NORTH_FLAG = class_259.method_1084(POLE, BAR_1);
        EAST_FLAG = class_259.method_1084(POLE, BAR_2);
        SOUTH_FLAG = class_259.method_1084(POLE, BAR_3);
        WEST_FLAG = class_259.method_1084(POLE, BAR_4);
    }

}