package net.adventurez.block.entity;

import net.adventurez.entity.BlackstoneGolemEntity;
import net.adventurez.init.BlockInit;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.EntityInit;
import net.adventurez.init.ItemInit;
import net.adventurez.init.SoundInit;
import net.adventurez.init.TagInit;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2398;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2510;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_7225.class_7874;

public class ChiseledPolishedBlackstoneHolderEntity extends class_2586 implements class_1263 {
    private class_2371<class_1799> inventory;
    private boolean startBuildingGolem = false;
    private int buildGolemCounter = 0;
    private int tickCounter = 0;

    public ChiseledPolishedBlackstoneHolderEntity(class_2338 pos, class_2680 state) {
        super(BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER_ENTITY, pos, state);
        this.inventory = class_2371.method_10213(1, class_1799.field_8037);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        inventory.clear();
        class_1262.method_5429(nbt, inventory, registryLookup);
        buildGolemCounter = nbt.method_10550("buildcounter");
        tickCounter = nbt.method_10550("tickcounter");
        startBuildingGolem = nbt.method_10577("startbuilding");
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426(nbt, inventory, registryLookup);
        nbt.method_10569("buildcounter", buildGolemCounter);
        nbt.method_10569("tickcounter", tickCounter);
        nbt.method_10556("startbuilding", startBuildingGolem);
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, ChiseledPolishedBlackstoneHolderEntity blockEntity) {
        blockEntity.tick();
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, ChiseledPolishedBlackstoneHolderEntity blockEntity) {
        blockEntity.tick();
    }

    public boolean isValid(class_1937 world, class_2338 pos, class_2680 state) {
        int stoneCounter;
        int stoneCounter2;
        int stoneCounter3 = 0;
        for (stoneCounter = 1; stoneCounter < 10; stoneCounter++) {
            for (stoneCounter2 = -4; stoneCounter2 < 5; stoneCounter2++) {
                class_2680 stoneState = this.method_10997().method_8320(pos.method_10076(stoneCounter).method_10089(stoneCounter2));
                if (stoneState.method_26164(TagInit.PLATFORM_NETHER_BLOCKS)) {
                    stoneCounter3++;
                }
            }
        }
        if (stoneCounter3 == 81) {
            return true;
        }
        return false;
    }

    public void tick() {
        if (!this.method_5442()) {
            if (!this.method_10997().method_8320(field_11867.method_10084()).method_26215()) {
                if (!this.method_10997().method_8608()) {
                    class_1264.method_17349(field_11863, field_11867, inventory);
                    inventory.clear();
                }
                tickCounter = -1;
            } else if (ConfigInit.CONFIG.allow_blackstone_golem_summoning) {
                this.tickCounter++;
                this.method_10997();
                if (tickCounter > 40 && this.method_5438(0).method_31574(ItemInit.GILDED_BLACKSTONE_SHARD) && this.method_10997().method_27983() == class_1937.field_25180) {
                    this.update();
                    tickCounter = 0;
                }
            }
        }
        if (startBuildingGolem == true) {
            this.buildStructure();
        }
    }

    private void update() {
        class_2680 state = this.method_11010();
        class_2338 secondHolderPos = this.method_11016().method_10076(10);
        class_2338 thirdHolderPos = this.method_11016().method_10089(5).method_10076(5);
        class_2338 fourthHolderPos = this.method_11016().method_10088(5).method_10076(5);
        class_2680 north = this.method_10997().method_8320(this.method_11016().method_10076(10));
        class_2680 east = this.method_10997().method_8320(this.method_11016().method_10089(5).method_10076(5));
        class_2680 west = this.method_10997().method_8320(this.method_11016().method_10088(5).method_10076(5));
        if (north.method_26204() == BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER && east.method_26204() == BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER
                && west.method_26204() == BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER) {
            if (this.method_10997().method_8608()) {
                // Visuals?
            }
            if (!this.method_5442() && !BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER_ENTITY.method_24182(field_11863, secondHolderPos).method_5442()
                    && !BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER_ENTITY.method_24182(field_11863, thirdHolderPos).method_5442()
                    && !BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER_ENTITY.method_24182(field_11863, fourthHolderPos).method_5442()) {
                if (this.isValid(this.method_10997(), this.method_11016(), state)) {
                    BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER_ENTITY.method_24182(field_11863, this.method_11016().method_10076(10)).method_5448();
                    BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER_ENTITY.method_24182(field_11863, this.method_11016().method_10089(5).method_10076(5)).method_5448();
                    BlockInit.CHISELED_POLISHED_BLACKSTONE_HOLDER_ENTITY.method_24182(field_11863, this.method_11016().method_10088(5).method_10076(5)).method_5448();
                    this.method_5448();
                    this.method_5431();
                    startBuildingGolem = true;
                    if (this.method_10997().method_8608()) {
                        for (int counting = 0; counting < 20; counting++) {
                            double d = (double) this.method_11016().method_10263() + (double) this.method_10997().method_8409().method_43057();
                            double e = (double) this.method_11016().method_10264() + (double) this.method_10997().method_8409().method_43057() + 1D;
                            double f = (double) this.method_11016().method_10260() + (double) this.method_10997().method_8409().method_43057();

                            double d2 = (double) secondHolderPos.method_10263() + (double) this.method_10997().method_8409().method_43057();
                            double e2 = (double) secondHolderPos.method_10264() + (double) this.method_10997().method_8409().method_43057() + 1D;
                            double f2 = (double) secondHolderPos.method_10260() + (double) this.method_10997().method_8409().method_43057();

                            double d3 = (double) thirdHolderPos.method_10263() + (double) this.method_10997().method_8409().method_43057();
                            double e3 = (double) thirdHolderPos.method_10264() + (double) this.method_10997().method_8409().method_43057() + 1D;
                            double f3 = (double) thirdHolderPos.method_10260() + (double) this.method_10997().method_8409().method_43057();

                            double d4 = (double) fourthHolderPos.method_10263() + (double) this.method_10997().method_8409().method_43057();
                            double e4 = (double) fourthHolderPos.method_10264() + (double) this.method_10997().method_8409().method_43057() + 1D;
                            double f4 = (double) fourthHolderPos.method_10260() + (double) this.method_10997().method_8409().method_43057();

                            this.method_10997().method_8406(class_2398.field_11251, d, e, f, 0.0D, 0.0D, 0.0D);
                            this.method_10997().method_8406(class_2398.field_11251, d2, e2, f2, 0.0D, 0.0D, 0.0D);
                            this.method_10997().method_8406(class_2398.field_11251, d3, e3, f3, 0.0D, 0.0D, 0.0D);
                            this.method_10997().method_8406(class_2398.field_11251, d4, e4, f4, 0.0D, 0.0D, 0.0D);

                        }
                    }
                }
            }
        }

    }

    private void buildStructure() {
        buildGolemCounter++;
        if (!this.method_10997().method_8608()) {
            // First Layer
            if (buildGolemCounter == 30) {
                this.method_10997().method_8652(this.method_11016().method_10084().method_10076(2).method_10089(2), class_2246.field_23870.method_9564(), 3);
                this.method_10997().method_8652(this.method_11016().method_10084().method_10076(2).method_10088(2), class_2246.field_23870.method_9564(), 3);
                this.method_10997().method_8652(this.method_11016().method_10084().method_10076(3).method_10089(2),
                        class_2246.field_23870.method_9564().method_11657(class_2510.field_11572, class_2760.field_12619).method_11657(class_2510.field_11571, class_2350.field_11035), 3);
                this.method_10997().method_8652(this.method_11016().method_10084().method_10076(3).method_10088(2),
                        class_2246.field_23870.method_9564().method_11657(class_2510.field_11572, class_2760.field_12619).method_11657(class_2510.field_11571, class_2350.field_11035), 3);
                this.method_10997().method_8652(this.method_11016().method_10084().method_10076(7).method_10078(), class_2246.field_23869.method_9564(), 3);
                this.method_10997().method_8652(this.method_11016().method_10084().method_10076(7).method_10067(), class_2246.field_23869.method_9564(), 3);
                this.method_10997().method_8396(null, this.method_11016(), class_3417.field_14574, class_3419.field_15245, 1F, 1F);
            }
            // Second Layer
            if (buildGolemCounter == 60) {
                this.method_10997().method_8652(this.method_11016().method_10086(2).method_10076(3).method_10089(2), class_2246.field_23870.method_9564(), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(2).method_10076(3).method_10088(2), class_2246.field_23870.method_9564(), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(2).method_10076(4).method_10089(2),
                        class_2246.field_23870.method_9564().method_11657(class_2510.field_11572, class_2760.field_12619).method_11657(class_2510.field_11571, class_2350.field_11035), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(2).method_10076(4).method_10088(2),
                        class_2246.field_23870.method_9564().method_11657(class_2510.field_11572, class_2760.field_12619).method_11657(class_2510.field_11571, class_2350.field_11035), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(2).method_10076(6).method_10078(), class_2246.field_23872.method_9564().method_11657(class_2482.field_11501, class_2771.field_12679), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(2).method_10076(6).method_10067(), class_2246.field_23872.method_9564().method_11657(class_2482.field_11501, class_2771.field_12679), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(2).method_10076(7).method_10078(), class_2246.field_23869.method_9564(), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(2).method_10076(7).method_10067(), class_2246.field_23869.method_9564(), 3);
                this.method_10997().method_8396(null, this.method_11016(), class_3417.field_14574, class_3419.field_15245, 1F, 1F);
            }
            // Third Layer
            if (buildGolemCounter == 90) {
                this.method_10997().method_8652(this.method_11016().method_10086(3).method_10076(4).method_10089(2), class_2246.field_23870.method_9564(), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(3).method_10076(4).method_10088(2), class_2246.field_23870.method_9564(), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(3).method_10076(5).method_10089(2), class_2246.field_23869.method_9564(), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(3).method_10076(5).method_10088(2), class_2246.field_23869.method_9564(), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(3).method_10076(6).method_10089(2), class_2246.field_23869.method_9564(), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(3).method_10076(6).method_10088(2), class_2246.field_23869.method_9564(), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(3).method_10076(7).method_10078(), class_2246.field_23870.method_9564().method_11657(class_2510.field_11571, class_2350.field_11035), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(3).method_10076(7).method_10067(), class_2246.field_23870.method_9564().method_11657(class_2510.field_11571, class_2350.field_11035), 3);
                for (int i = -1; i < 2; i++) {
                    this.method_10997().method_8652(this.method_11016().method_10086(3).method_10076(5).method_10089(i), class_2246.field_23869.method_9564(), 3);
                    this.method_10997().method_8652(this.method_11016().method_10086(3).method_10076(6).method_10089(i), class_2246.field_23869.method_9564(), 3);
                }
                this.method_10997().method_8396(null, this.method_11016(), class_3417.field_14574, class_3419.field_15245, 1F, 1F);
            }
            // Fourth Layer
            if (buildGolemCounter == 120) {
                this.method_10997().method_8652(this.method_11016().method_10086(4).method_10076(5).method_10089(2), class_2246.field_23870.method_9564().method_11657(class_2510.field_11571, class_2350.field_11039), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(4).method_10076(5).method_10088(2), class_2246.field_23870.method_9564().method_11657(class_2510.field_11571, class_2350.field_11034), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(4).method_10076(6).method_10089(2),
                        class_2246.field_23870.method_9564().method_11657(class_2510.field_11571, class_2350.field_11039).method_11657(class_2510.field_11565, class_2778.field_12708), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(4).method_10076(6).method_10088(2),
                        class_2246.field_23870.method_9564().method_11657(class_2510.field_11571, class_2350.field_11034).method_11657(class_2510.field_11565, class_2778.field_12709), 3);
                for (int i = -1; i < 2; i++) {
                    this.method_10997().method_8652(this.method_11016().method_10086(4).method_10076(5).method_10089(i), class_2246.field_23869.method_9564(), 3);
                    this.method_10997().method_8652(this.method_11016().method_10086(4).method_10076(6).method_10089(i), class_2246.field_23870.method_9564().method_11657(class_2510.field_11571, class_2350.field_11035), 3);
                }
                this.method_10997().method_8652(this.method_11016().method_10086(4).method_10076(4), class_2246.field_23869.method_9564(), 3);
                this.method_10997().method_8652(this.method_11016().method_10086(5).method_10076(4), class_2246.field_23872.method_9564(), 3);
                this.method_10997().method_8396(null, this.method_11016(), class_3417.field_14574, class_3419.field_15245, 1F, 1F);
            }
            if (buildGolemCounter >= 150) {
                for (int i = 1; i < 6; i++) {
                    for (int o = -4; o < 6; o++) {
                        for (int u = 1; u < 10; u++) {
                            this.method_10997().method_22352(this.method_11016().method_10086(i).method_10089(o).method_10076(u), false);
                        }
                    }
                }
                BlackstoneGolemEntity stoneGolemEntity = (BlackstoneGolemEntity) EntityInit.BLACKSTONE_GOLEM.method_5883(field_11863);
                class_2338 spawnPos = new class_2338(this.method_11016().method_10263(), this.method_11016().method_10264() + 1, this.method_11016().method_10260() - 5);
                stoneGolemEntity.method_5725(spawnPos, 0.0F, 0.0F);
                stoneGolemEntity.method_5943(((class_3218) this.method_10997()), this.method_10997().method_8404(this.method_11016()), class_3730.field_16474, null);
                stoneGolemEntity.sendtoEntity();
                this.method_10997().method_8649(stoneGolemEntity);
                this.method_10997().method_8396(null, this.method_11016(), SoundInit.GOLEM_SPAWN_EVENT, class_3419.field_15251, 1F, 1F);
            }
        } else {
            double d = (double) this.method_11016().method_10263() + (double) this.method_10997().method_8409().method_43057();
            double e = (double) this.method_11016().method_10264() + (double) this.method_10997().method_8409().method_43057() + 1D;
            double f = (double) this.method_11016().method_10260() + (double) this.method_10997().method_8409().method_43057();
            if (buildGolemCounter > 0 && buildGolemCounter < 26) {
                this.method_10997().method_8406(class_2398.field_11251, d + 2, e, f - 2, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d - 2, e, f - 2, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d + 2, e, f - 3, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d - 2, e, f - 3, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d + 1, e, f - 7, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d - 1, e, f - 7, 0.0D, 0.0D, 0.0D);
            }
            if (buildGolemCounter > 30 && buildGolemCounter < 56) {
                this.method_10997().method_8406(class_2398.field_11251, d + 2, e + 1, f - 3, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d - 2, e + 1, f - 3, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d + 2, e + 1, f - 4, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d - 2, e + 1, f - 4, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d + 1, e + 1, f - 6, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d - 1, e + 1, f - 6, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d + 1, e + 1, f - 7, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d - 1, e + 1, f - 7, 0.0D, 0.0D, 0.0D);
            }
            if (buildGolemCounter > 60 && buildGolemCounter < 86) {
                this.method_10997().method_8406(class_2398.field_11251, d + 2, e + 2, f - 4, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d - 2, e + 2, f - 4, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d + 2, e + 2, f - 5, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d - 2, e + 2, f - 5, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d + 2, e + 2, f - 6, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d - 2, e + 2, f - 6, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d + 1, e + 2, f - 7, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d - 1, e + 2, f - 7, 0.0D, 0.0D, 0.0D);
                for (int i = -1; i < 2; i++) {
                    this.method_10997().method_8406(class_2398.field_11251, d - i, e + 2, f - 5, 0.0D, 0.0D, 0.0D);
                    this.method_10997().method_8406(class_2398.field_11251, d - i, e + 2, f - 6, 0.0D, 0.0D, 0.0D);
                }
            }
            if (buildGolemCounter > 90 && buildGolemCounter < 116) {
                this.method_10997().method_8406(class_2398.field_11251, d + 2, e + 3, f - 5, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d - 2, e + 3, f - 5, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d + 2, e + 3, f - 6, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d - 2, e + 3, f - 6, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d, e + 3, f - 4, 0.0D, 0.0D, 0.0D);
                this.method_10997().method_8406(class_2398.field_11251, d, e + 4, f - 4, 0.0D, 0.0D, 0.0D);
                for (int i = -1; i < 2; i++) {
                    this.method_10997().method_8406(class_2398.field_11251, d - i, e + 3, f - 5, 0.0D, 0.0D, 0.0D);
                    this.method_10997().method_8406(class_2398.field_11251, d - i, e + 3, f - 6, 0.0D, 0.0D, 0.0D);
                }
            }
        }

        if (buildGolemCounter >= 150) {
            startBuildingGolem = false;
            buildGolemCounter = 0;
        }
    }

    @Override
    public void method_5431() {
        super.method_5431();
        sendUpdate();
    }

    private void sendUpdate() {
        if (this.method_10997() != null) {
            class_2680 state = this.method_10997().method_8320(this.field_11867);
            this.method_10997().method_8413(this.field_11867, state, state, 3);
        }
    }

    @Override
    public void method_5448() {
        this.inventory.clear();
        this.method_5431();
    }

    @Override
    public int method_5439() {
        return 1;
    }

    @Override
    public boolean method_5442() {
        return this.method_5438(0).method_7960();
    }

    @Override
    public class_1799 method_5438(int slot) {
        return this.inventory.get(0);
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        class_1799 result = class_1262.method_5430(this.inventory, slot, 1);
        this.method_5431();
        return result;
    }

    @Override
    public class_1799 method_5441(int slot) {
        this.method_5431();
        return class_1262.method_5428(this.inventory, slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(0, stack);
        this.method_5431();
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return true;
    }

    @Override
    public class_2622 method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887(class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

}