package net.adventurez.block.entity;

import net.adventurez.entity.DragonEntity;
import net.adventurez.entity.TheEyeEntity;
import net.adventurez.init.BlockInit;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.EffectInit;
import net.adventurez.init.EntityInit;
import net.adventurez.init.TagInit;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_7225.class_7874;

public class DragonEggEntity extends class_2586 {
    private int overallSummoningTick;
    private int overallHatchingTick;
    private int hatchTick;
    private int summoningTick;
    private boolean isHatchAble;

    public DragonEggEntity(class_2338 pos, class_2680 state) {
        super(BlockInit.DRAGON_EGG_ENTITY, pos, state);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        hatchTick = nbt.method_10550("Hatch_Tick");
        isHatchAble = nbt.method_10577("Hatch_Able");
        summoningTick = nbt.method_10550("Summoning_Tick");
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10556("Hatch_Able", isHatchAble);
        nbt.method_10569("Hatch_Tick", hatchTick);
        nbt.method_10569("Summoning_Tick", summoningTick);
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, DragonEggEntity blockEntity) {
        blockEntity.tick();
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, DragonEggEntity blockEntity) {
        blockEntity.tick();
    }

    @Override
    public void method_5431() {
        super.method_5431();
        sendUpdate();
    }

    private void sendUpdate() {
        if (this.method_10997() != null) {
            class_2680 state = this.method_10997().method_8320(this.field_11867);
            (this.method_10997()).method_8413(this.field_11867, state, state, 3);
        }
    }

    private boolean isValid(class_1937 world, class_2338 pos, class_2680 state) {
        int stoneCounter;
        int stoneCounter2;
        int stoneCounter3 = 0;
        int stoneCounter4;
        int stoneCounter5;
        class_2680 rod_1 = world.method_8320(pos.method_10095().method_10078());
        class_2680 rod_2 = world.method_8320(pos.method_10095().method_10067());
        class_2680 rod_3 = world.method_8320(pos.method_10072().method_10078());
        class_2680 rod_4 = world.method_8320(pos.method_10072().method_10067());
        if (rod_1.equals(class_2246.field_10455.method_9564()) && rod_2.equals(class_2246.field_10455.method_9564()) && rod_3.equals(class_2246.field_10455.method_9564())
                && rod_4.equals(class_2246.field_10455.method_9564())) {
            for (stoneCounter4 = -1; stoneCounter4 < 2; stoneCounter4++) {
                for (stoneCounter5 = -1; stoneCounter5 < 2; stoneCounter5++) {
                    class_2680 middleState = world.method_8320(pos.method_10076(stoneCounter4).method_10089(stoneCounter5).method_10074());
                    if (middleState.method_26204().equals(class_2246.field_22423)) {
                        stoneCounter3++;
                    }
                }
            }
            for (stoneCounter = -2; stoneCounter < 3; stoneCounter++) {
                for (stoneCounter2 = -2; stoneCounter2 < 3; stoneCounter2++) {
                    class_2680 baseState = world.method_8320(pos.method_10076(stoneCounter).method_10089(stoneCounter2).method_10087(2));
                    if (baseState.method_26164(TagInit.PLATFORM_END_BLOCKS)) {
                        stoneCounter3++;
                    }
                }
            }
        }
        if (stoneCounter3 == 34) {
            return true;
        } else {
            return false;
        }
    }

    private void tick() {
        this.updateTheEyeSummoning();
        this.updateDragonHatching();
    }

    private void updateDragonHatching() {
        if (ConfigInit.CONFIG.allow_dragon_hatching && !this.method_10997().method_8608()) {
            overallHatchingTick++;
            if (overallHatchingTick == 20) {
                if (!this.isHatchAble) {
                    if (((class_3218) this.method_10997()).method_29198() != null && !((class_3218) this.method_10997()).method_29198().method_12536())
                        return;
                    class_1657 playerEntity = this.method_10997().method_18459(this.method_11016().method_10263() + 0.5D, this.method_11016().method_10264(), this.method_11016().method_10260() + 0.5D, 2.5D, true);
                    if (playerEntity != null && playerEntity.method_6059(EffectInit.FAME))
                        enableEggHatching();
                } else {
                    this.hatchTick++;
                    if (this.hatchTick % 60 == 0) {
                        for (int i = 0; i < 20; i++) {
                            double d = (double) field_11867.method_10263() + (double) this.method_10997().method_8409().method_43057();
                            double e = (double) field_11867.method_10264() + (double) this.method_10997().method_8409().method_43057();
                            double f = (double) field_11867.method_10260() + (double) this.method_10997().method_8409().method_43057();
                            ((class_3218) this.method_10997()).method_14199(class_2398.field_11211, d, e, f, 0, 0.0D, 0.0D, 0.0D, 0.01D);
                        }
                    }
                    if (this.hatchTick >= 598) {
                        this.method_10997().method_22352(this.field_11867, false);
                        DragonEntity dragonEntity = EntityInit.DRAGON.method_5883(this.method_10997());
                        dragonEntity.method_5808((double) this.method_11016().method_10263() + 0.5D, (double) this.method_11016().method_10264() + 0.55D, (double) this.method_11016().method_10260() + 0.5D, 90F, 0.0F);
                        dragonEntity.method_5943(((class_3218) this.method_10997()), this.method_10997().method_8404(field_11867), class_3730.field_16474, null);
                        dragonEntity.setSize(1);
                        this.method_10997().method_8649(dragonEntity);
                    }
                }

            }
            if (overallHatchingTick >= 20) {
                overallHatchingTick = 0;
            }
        }
    }

    private void updateTheEyeSummoning() {
        if (ConfigInit.CONFIG.allow_the_eye_summoning) {
            if (this.method_10997().method_8320(field_11867.method_10074()).equals(class_2246.field_22423.method_9564()) && this.method_10997().method_27983() == class_1937.field_25181) {
                overallSummoningTick++;
                class_2680 state = this.method_11010();
                if (overallSummoningTick == 20 && this.isValid(this.method_10997(), field_11867, state)) {
                    summoningTick++;
                    if (!this.method_10997().method_8608() && summoningTick >= 60) {
                        TheEyeEntity theEyeEntity = (TheEyeEntity) EntityInit.THE_EYE.method_5883(this.method_10997());
                        theEyeEntity.method_5808((double) this.method_11016().method_10263() + 0.5D, (double) this.method_11016().method_10264() + 0.55D, (double) this.method_11016().method_10260() + 0.5D, 90F, 0.0F);
                        theEyeEntity.method_5943(((class_3218) this.method_10997()), this.method_10997().method_8404(field_11867), class_3730.field_16474, null);
                        theEyeEntity.setEyeInvulnerabletime();
                        this.method_10997().method_8649(theEyeEntity);
                        this.method_10997().method_22352(field_11867, false);
                    }
                }
                if (overallSummoningTick >= 20) {
                    overallSummoningTick = 0;
                }
                if (this.method_10997().method_8608() && summoningTick != 0) {
                    if (summoningTick % 10 == 0) {
                        this.dragonAltartParticle(1);
                    }
                    if (summoningTick % 5 == 0) {
                        this.dragonAltartParticle(2);
                    }
                }

            }
        }
    }

    private void dragonAltartParticle(int distance) {
        double d = (double) field_11867.method_10089(distance).method_10076(distance).method_10263() + (double) field_11863.field_9229.method_43057();
        double e = (double) field_11867.method_10086(1 - distance).method_10264() + (double) field_11863.field_9229.method_43057() * 2.0D;
        double f = (double) field_11867.method_10089(distance).method_10076(distance).method_10260() + (double) field_11863.field_9229.method_43057();
        double d1 = (double) field_11867.method_10088(distance).method_10076(distance).method_10263() + (double) field_11863.field_9229.method_43057();
        double e1 = (double) field_11867.method_10086(1 - distance).method_10264() + (double) field_11863.field_9229.method_43057() * 2.0D;
        double f1 = (double) field_11867.method_10088(distance).method_10076(distance).method_10260() + (double) field_11863.field_9229.method_43057();
        double d2 = (double) field_11867.method_10077(distance).method_10089(distance).method_10263() + (double) field_11863.field_9229.method_43057();
        double e2 = (double) field_11867.method_10086(1 - distance).method_10264() + (double) field_11863.field_9229.method_43057() * 2.0D;
        double f2 = (double) field_11867.method_10077(distance).method_10089(distance).method_10260() + (double) field_11863.field_9229.method_43057();
        double d3 = (double) field_11867.method_10077(distance).method_10088(distance).method_10263() + (double) field_11863.field_9229.method_43057();
        double e3 = (double) field_11867.method_10086(1 - distance).method_10264() + (double) field_11863.field_9229.method_43057() * 2.0D;
        double f3 = (double) field_11867.method_10077(distance).method_10088(distance).method_10260() + (double) field_11863.field_9229.method_43057();
        field_11863.method_8406(class_2398.field_11207, d, e, f, 0.0D, 0.0D, 0.0D);
        field_11863.method_8406(class_2398.field_11207, d1, e1, f1, 0.0D, 0.0D, 0.0D);
        field_11863.method_8406(class_2398.field_11207, d2, e2, f2, 0.0D, 0.0D, 0.0D);
        field_11863.method_8406(class_2398.field_11207, d3, e3, f3, 0.0D, 0.0D, 0.0D);
    }

    public void enableEggHatching() {
        this.isHatchAble = true;
    }

}