package net.adventurez.block.entity;

import java.util.List;

import net.adventurez.init.BlockInit;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_4140;
import net.minecraft.class_4836;
import net.minecraft.class_7225.class_7874;

public class PiglinFlagEntity extends class_2586 {
    private int flagWave;

    public PiglinFlagEntity(class_2338 pos, class_2680 state) {
        super(BlockInit.PIGLIN_FLAG_ENTITY, pos, state);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.flagWave = nbt.method_10550("Flagging");
    }

    @Override
    public void method_11007(class_2487 nbt, class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("Flagging", flagWave);
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, PiglinFlagEntity blockEntity) {
        blockEntity.update();
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, PiglinFlagEntity blockEntity) {
        blockEntity.update();
    }

    @Override
    public void method_5431() {
        super.method_5431();
        this.sendUpdate();
    }

    private void sendUpdate() {
        if (this.method_10997() != null) {
            class_2680 state = this.method_10997().method_8320(this.method_11016());
            this.method_10997().method_8413(this.method_11016(), state, state, 3);
        }
    }

    private void update() {
        if (this.method_10997().method_8510() % 20 == 0) {
            if (this.flagWave < 120) {
                this.flagWave++;
            }
            if (this.flagWave >= 120 && this.method_10997().method_8604((double) this.method_11016().method_10263(), (double) this.method_11016().method_10264(), (double) this.method_11016().method_10260(), 3D, null) != null) {
                this.getPiglins();
                this.method_5431();
                if (this.method_10997().method_8608()) {
                    for (int i = 0; i < 20; i++) {
                        double d = (double) this.method_11016().method_10263() + (double) this.method_10997().method_8409().method_43057();
                        double e = (double) this.method_11016().method_10264() + (double) this.method_10997().method_8409().method_43057() * 2.0F;
                        double f = (double) this.method_11016().method_10260() + (double) this.method_10997().method_8409().method_43057();
                        this.method_10997().method_8406(class_2398.field_11211, d, e, f, 0.0D, 1.0D, 0.0D);
                    }
                }
                this.flagWave = 0;
            }
        }
    }

    public void getPiglins() {
        List<class_1309> list = this.method_10997().method_8390(class_1309.class, new class_238(this.method_11016()).method_1014(40D), class_1301.field_6155);
        for (int i = 0; i < list.size(); ++i) {
            class_1309 entity = list.get(i);
            if (entity.method_5864() == class_1299.field_22281) {
                class_4836 piglin = (class_4836) entity;
                if (piglin.method_18868().method_18896(class_4140.field_22355)) {
                    piglin.method_18868().method_18875(class_4140.field_22333);
                    piglin.method_18868().method_18875(class_4140.field_22355);
                    piglin.method_18868().method_18875(class_4140.field_18445);
                }
            }
        }
    }

}