package net.adventurez.block.renderer;

import net.adventurez.block.PiglinFlag;
import net.adventurez.block.entity.PiglinFlagEntity;
import net.adventurez.init.RenderInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;

@Environment(EnvType.CLIENT)
public class PiglinFlagRenderer implements class_827<PiglinFlagEntity> {

    private static final class_2960 TEXTURE = class_2960.method_60655("adventurez", "textures/block/piglin_flag.png");
    private final class_630 flag;
    private final class_630 holder;

    public PiglinFlagRenderer(class_5614.class_5615 ctx) {
        this.holder = ctx.method_32140(RenderInit.PIGLIN_FLAG_LAYER).method_32086("holder");
        this.flag = holder.method_32086("flag");
    }

    public PiglinFlagRenderer(class_630 root) {
        this.holder = root.method_32086("holder");
        this.flag = holder.method_32086("flag");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 holder = modelPartData.method_32117(
                "holder", class_5606.method_32108().method_32101(0, 42).method_32098(-2.0F, 0.0F, -2.0F, 4.0F, 11.0F, 4.0F, new class_5605(0.0F)).method_32101(10, 20)
                        .method_32098(-2.0F, 40.0F, -2.0F, 4.0F, 4.0F, 18.0F, new class_5605(0.0F)).method_32101(36, 0).method_32098(-1.0F, 11.0F, -1.0F, 2.0F, 29.0F, 2.0F, new class_5605(0.0F)),
                class_5603.method_32090(0.0F, -20.0F, 0.0F));

        holder.method_32117("flag", class_5606.method_32108().method_32101(0, 0).method_32098(0.0F, -24.0F, -6.6F, 0.0F, 24.0F, 14.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 40.0F, 8.0F));
        return class_5607.method_32110(modelData, 64, 64);
    }

    @Override
    public void render(PiglinFlagEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumerProvider, int light, int overlay) {
        matrices.method_22903();
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578(TEXTURE));
        class_2680 state = entity.method_11010();
        class_2350 blockDirection = state.method_11654(class_2383.field_11177);
        if (state.method_26204() instanceof PiglinFlag) {
            if (blockDirection.equals(class_2350.field_11043)) {
                matrices.method_22904(1D, 0D, 1D);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(180F));
            } else if (blockDirection.equals(class_2350.field_11034)) {
                matrices.method_22904(0D, 0D, 1D);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(90F));
            } else if (blockDirection.equals(class_2350.field_11035)) {
            } else if (blockDirection.equals(class_2350.field_11039)) {
                matrices.method_22904(1D, 0D, 0D);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(270F));
            }
        }
        matrices.method_22904(0.5D, 1.25D, 0.5D);
        class_2338 blockPos = entity.method_11016();
        long worldTime = entity.method_10997().method_8510();
        float goodFloat = ((float) Math.floorMod((long) (blockPos.method_10263() * 7 + blockPos.method_10264() * 9 + blockPos.method_10260() * 13) + worldTime, 100L) + tickDelta) / 100.0F;
        flag.field_3674 = class_3532.method_15362(6.2831855F * goodFloat) / 4;
        holder.method_22698(matrices, vertexConsumer, light, overlay);
        matrices.method_22909();
    }
}