package net.adventurez.entity;

import org.jetbrains.annotations.Nullable;

import net.adventurez.entity.nonliving.AmethystShardEntity;
import net.adventurez.init.ParticleInit;
import net.adventurez.init.SoundInit;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2945.class_9222;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public class AmethystGolemEntity extends class_1588 {

    public static final class_2940<Integer> BACK_CRYSTALS;
    public static final class_2940<Boolean> DEEPSLATE_VARIANT;
    private int grow = 0;
    private boolean isStronger = false;

    public AmethystGolemEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);

    }

    public static class_5132.class_5133 createAmethystGolemAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 40.0D).method_26868(class_5134.field_23721, 8.0D)
                .method_26868(class_5134.field_23719, 0.24D).method_26868(class_5134.field_23717, 20.0D).method_26868(class_5134.field_23724, 1.0D);
    }

    @Override
    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, new class_1366(this, 0.85D, false));
        this.field_6201.method_6277(2, new ThrowShardGoal(this));
        this.field_6201.method_6277(5, new class_1361(this, class_1657.class, 8.0F));
        this.field_6201.method_6277(6, new class_1376(this));
        this.field_6201.method_6277(7, new class_1379(this, 0.9D));
        this.field_6185.method_6277(1, new class_1400<>(this, class_1657.class, true));
    }

    public static boolean canSpawn(class_1299<AmethystGolemEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return (method_20680(type, world, spawnReason, pos, random) && !world.method_8311(pos)) || spawnReason == class_3730.field_16469;
    }

    @Override
    protected void method_5693(class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(BACK_CRYSTALS, 4);
        builder.method_56912(DEEPSLATE_VARIANT, false);
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.field_6011.method_12778(BACK_CRYSTALS, tag.method_10550("Crystals"));
        this.field_6011.method_12778(DEEPSLATE_VARIANT, tag.method_10577("DeepslateGolem"));
        this.grow = tag.method_10550("GrowAmethysts");
        this.isStronger = tag.method_10577("StrongerGolem");
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Crystals", this.field_6011.method_12789(BACK_CRYSTALS));
        tag.method_10556("DeepslateGolem", this.field_6011.method_12789(DEEPSLATE_VARIANT));
        tag.method_10569("GrowAmethysts", this.grow);
        tag.method_10556("StrongerGolem", this.isStronger);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608() && this.field_6011.method_12789(BACK_CRYSTALS) < 4) {
            this.grow++;
            if (this.grow >= 3600) {
                this.field_6011.method_12778(BACK_CRYSTALS, this.field_6011.method_12789(BACK_CRYSTALS) + 1);
                this.method_5996(class_5134.field_23716).method_6192(this.method_45326(class_5134.field_23716) + 10.0D);
                this.method_6025(10F);
                this.grow = 0;
            }
        }
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        int random = this.method_59922().method_43048(5);
        this.field_6011.method_12778(BACK_CRYSTALS, random);
        if (random > 0) {
            this.method_5996(class_5134.field_23716).method_6192(this.method_45326(class_5134.field_23716) + random * 10.0D);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    @Override
    public boolean method_5974(double distanceSquared) {
        return false;
    }

    @Override
    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801) {
            this.method_31472();
        }
    }

    @Override
    protected class_3414 method_5994() {
        return SoundInit.AMETHYST_GOLEM_IDLE_EVENT;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return SoundInit.AMETHYST_GOLEM_HIT_EVENT;
    }

    @Override
    protected class_3414 method_6002() {
        return SoundInit.AMETHYST_GOLEM_DEATH_EVENT;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(SoundInit.AMETHYST_GOLEM_WALK_EVENT, 0.9F, 1.0F);
    }

    public void amethystGolemRageMode() {
        if (this.method_37908() instanceof class_3218 serverWorld) {
            this.method_5996(class_5134.field_23724).method_6192(this.method_45326(class_5134.field_23724) + 2.0D);
            if (!this.isStronger) {
                this.method_5996(class_5134.field_23719).method_6192(this.method_45326(class_5134.field_23719) + 0.1D);
            }
            serverWorld.method_43129(null, this, SoundInit.AMETHYST_GOLEM_RAGE_EVENT, class_3419.field_15251, 1.0F, 1.0F);
            for (int i = 0; i < 20; i++) {
                double d = (double) this.method_23317() - 1.0F + this.method_37908().method_8409().method_43057() * 2.0F;
                double e = (double) ((float) this.method_23319() + this.method_37908().method_8409().method_43057() * 0.1F);
                double f = (double) this.method_23321() - 1.0F + this.method_37908().method_8409().method_43057() * 2.0F;
                double g = (double) (this.method_37908().method_8409().method_43057() * 0.4D);
                double h = (double) this.method_37908().method_8409().method_43057() * 0.2D;
                double l = (double) (this.method_37908().method_8409().method_43057() * 0.4D);
                ((class_3218) this.method_37908()).method_14199(ParticleInit.AMETHYST_SHARD_PARTICLE, d, e, f, 4, g, h, l, 1.0D);
            }
            this.isStronger = true;
        }
    }

    static {
        BACK_CRYSTALS = class_2945.method_12791(AmethystGolemEntity.class, class_2943.field_13327);
        DEEPSLATE_VARIANT = class_2945.method_12791(AmethystGolemEntity.class, class_2943.field_13323);
    }

    public static class ThrowShardGoal extends class_1352 {
        private final AmethystGolemEntity amethystGolemEntity;
        private int cooldown;
        private long lastUpdateTime;

        public ThrowShardGoal(AmethystGolemEntity amethystGolemEntity) {
            this.amethystGolemEntity = amethystGolemEntity;
        }

        @Override
        public boolean method_6264() {
            long l = this.amethystGolemEntity.method_37908().method_8510();
            if (l - this.lastUpdateTime < 100L || this.cooldown-- > 0) {
                return false;
            } else {
                this.lastUpdateTime = l;
                class_1309 livingEntity = this.amethystGolemEntity.method_5968();
                if (livingEntity == null) {
                    return false;
                } else if (!livingEntity.method_5805()) {
                    return false;
                } else {
                    return this.amethystGolemEntity.method_6057(livingEntity);
                }
            }
        }

        @Override
        public boolean method_6266() {
            class_1309 livingEntity = this.amethystGolemEntity.method_5968();
            if (livingEntity == null) {
                return false;
            } else if (!livingEntity.method_5805()) {
                return false;
            } else if (!this.amethystGolemEntity.method_18407(livingEntity.method_24515()) || !this.amethystGolemEntity.method_6057(livingEntity)) {
                return false;
            } else if (this.cooldown > 0) {
                return false;
            } else {
                return !(livingEntity instanceof class_1657) || !livingEntity.method_7325() && !((class_1657) livingEntity).method_7337();
            }
        }

        @Override
        public void method_6269() {
            this.amethystGolemEntity.method_6104(class_1268.field_5808);
            if (!this.amethystGolemEntity.method_37908().method_8608()) {
                this.amethystGolemEntity.method_37908().method_43129(null, this.amethystGolemEntity, SoundInit.ROCK_THROW_EVENT, class_3419.field_15251, 0.74F, 1.0F);
                AmethystShardEntity amethystShardEntity = new AmethystShardEntity(this.amethystGolemEntity, this.amethystGolemEntity.method_37908());
                amethystShardEntity.method_24919(amethystGolemEntity, amethystGolemEntity.method_36455(), amethystGolemEntity.method_36454(), -20.0F, 0.7F, this.amethystGolemEntity.method_59922().method_43057());
                this.amethystGolemEntity.method_37908().method_8649(amethystShardEntity);
            }
            this.cooldown = 80 + this.amethystGolemEntity.method_59922().method_43048(200);
            this.method_6270();
        }
    }

}
