package net.adventurez.entity;

import java.util.UUID;

import org.jetbrains.annotations.Nullable;

import net.adventurez.init.SoundInit;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5819;
import net.minecraft.class_6019;

public class BrownFungusEntity extends class_1314 implements class_5354 {
    private static final class_6019 ANGER_TIME_RANGE;
    private int angerTime;
    private UUID angryAt;

    public BrownFungusEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 2;
    }

    @Override
    public void method_5959() {
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1366(this, 1.2D, true));
        this.field_6201.method_6277(3, new class_1391(this, 1.25D, class_1856.method_8091(class_1802.field_8158), false));
        this.field_6201.method_6277(5, new class_1394(this, 1.0D));
        this.field_6201.method_6277(6, new class_1361(this, class_1657.class, 6.0F));
        this.field_6201.method_6277(7, new class_1376(this));
        this.field_6185.method_6277(1, new class_5398<>(this, true));
        this.field_6185.method_6277(2, new class_1400<>(this, class_1657.class, 10, true, false, this::method_29515));
        this.field_6185.method_6277(3, (new class_1399(this, new Class[0])).method_6318());
    }

    public static class_5132.class_5133 createBrownFungusAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0D).method_26868(class_5134.field_23719, 0.2D).method_26868(class_5134.field_23721, 1.0D)
                .method_26868(class_5134.field_23717, 32.0D);
    }

    public static boolean canSpawn(class_1299<BrownFungusEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(class_3481.field_35570) && world.method_22335(pos, 0) > 8;
    }

    @Override
    protected class_3414 method_5994() {
        return SoundInit.FUNGUS_IDLE_EVENT;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return SoundInit.FUNGUS_HURT_EVENT;
    }

    @Override
    protected class_3414 method_6002() {
        return SoundInit.FUNGUS_DEATH_EVENT;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14772, 0.15F, 1.0F);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.method_29517(nbt);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.method_29512(this.method_37908(), nbt);
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().method_8608()) {
            this.method_29510((class_3218) this.method_37908(), true);
            int randomMushroom = this.method_37908().method_8409().method_43048(20000);
            if (randomMushroom == 1997
                    && (this.method_37908().method_8320(this.method_24515().method_10074()).method_27852(class_2246.field_10402) || this.method_37908().method_8320(this.method_24515().method_10074()).method_27852(class_2246.field_10219))
                    && this.method_37908().method_8320(this.method_24515()).method_26215()) {
                this.method_37908().method_8501(this.method_24515(), class_2246.field_10251.method_9564());
            }
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_5526() != null && source.method_5526() instanceof class_1657 attacker) {
            this.method_29513(attacker.method_5667());
        }
        return !this.method_5679(source) && super.method_5643(source, amount);

    }

    @Override
    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    @Override
    public void method_29514(int ticks) {
        this.angerTime = ticks;
    }

    @Override
    public int method_29507() {
        return this.angerTime;
    }

    @Override
    public void method_29513(@Nullable UUID uuid) {
        this.angryAt = uuid;
    }

    @Override
    public UUID method_29508() {
        return this.angryAt;
    }

    @Override
    public int method_5945() {
        return 4;
    }

    @Override
    public boolean method_6121(class_1297 target) {
        if (!super.method_6121(target)) {
            return false;
        } else {
            if (!this.method_37908().method_8608() && target instanceof class_1309 && this.method_37908().method_8409().method_43048(160) > 100) {
                ((class_1309) target).method_37222(new class_1293(class_1294.field_5899, 80 + this.method_37908().method_8409().method_43048(100), 0, false, false), this);
            }
            return true;
        }
    }

    static {
        ANGER_TIME_RANGE = class_4802.method_24505(20, 60);
    }

}
