package net.adventurez.entity;

import java.util.EnumSet;

import net.adventurez.init.EntityInit;
import net.adventurez.init.SoundInit;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5532;

public class DeerEntity extends class_1429 {

    public DeerEntity(class_1299<? extends DeerEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createDeerAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0D).method_26868(class_5134.field_23719, 0.215D);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1374(this, 2.0D));
        this.field_6201.method_6277(2, new class_1341(this, 1.0D));
        this.field_6201.method_6277(3, new class_1391(this, 1.22D, class_1856.method_8091(class_1802.field_8602, class_1802.field_8256, class_1802.field_8471), true));
        this.field_6201.method_6277(4, new class_1353(this, 1.25D));
        this.field_6201.method_6277(5, new EscapePlayerGoal(this, 2.0D));
        this.field_6201.method_6277(6, new class_1394(this, 1.0D));
        this.field_6201.method_6277(7, new class_1361(this, class_1657.class, 6.0F));
        this.field_6201.method_6277(8, new class_1376(this));
    }

    @Override
    protected class_3414 method_5994() {
        return this.method_6109() ? SoundInit.BABY_DEER_IDLE_EVENT : SoundInit.DEER_IDLE_EVENT;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return this.method_6109() ? SoundInit.BABY_DEER_HURT_EVENT : SoundInit.DEER_HURT_EVENT;
    }

    @Override
    protected class_3414 method_6002() {
        return this.method_6109() ? SoundInit.BABY_DEER_HURT_EVENT : SoundInit.DEER_DEATH_EVENT;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14772, 0.15F, 1.0F);
    }

    @Override
    public DeerEntity method_5613(class_3218 serverWorld, class_1296 passiveEntity) {
        return EntityInit.DEER.method_5883(serverWorld);
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_1802.field_8602) || stack.method_31574(class_1802.field_8471) || stack.method_31574(class_1802.field_8256);
    }

    private class EscapePlayerGoal extends class_1352 {
        protected final DeerEntity deerEntity;
        protected final double speed;
        protected double targetX;
        protected double targetY;
        protected double targetZ;

        public EscapePlayerGoal(DeerEntity deerEntity, double speed) {
            this.deerEntity = deerEntity;
            this.speed = speed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        @Override
        public boolean method_6264() {
            if (this.deerEntity.method_37908().method_18460(this.deerEntity, 4.0D) == null) {
                return false;
            } else {
                return this.findTarget();
            }
        }

        private boolean findTarget() {
            class_243 vec3d = class_5532.method_31510(this.deerEntity, 12, 4);
            if (vec3d == null) {
                return false;
            } else {
                this.targetX = vec3d.field_1352;
                this.targetY = vec3d.field_1351;
                this.targetZ = vec3d.field_1350;
                return true;
            }
        }

        @Override
        public void method_6269() {
            this.deerEntity.method_5942().method_6337(this.targetX, this.targetY, this.targetZ, this.speed);
        }

        @Override
        public boolean method_6266() {
            return !this.deerEntity.method_5942().method_6357();
        }

    }

}
