package net.adventurez.entity;

import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.UUID;

import com.google.common.collect.UnmodifiableIterator;

import net.adventurez.entity.goal.DragonFindOwnerGoal;
import net.adventurez.entity.goal.DragonFlyRandomlyGoal;
import net.adventurez.entity.goal.DragonSitGoal;
import net.adventurez.entity.nonliving.FireBreathEntity;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.ItemInit;
import net.adventurez.init.SoundInit;
import net.adventurez.init.TagInit;
import net.adventurez.mixin.accessor.LivingEntityAccessor;
import net.adventurez.network.packet.DragonFireBreathPacket;
import net.adventurez.network.packet.VelocityPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2945.class_9222;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3321;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_3730;
import net.minecraft.class_3917;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5275;
import net.minecraft.class_5425;
import net.minecraft.class_6025;
import net.minecraft.class_746;
import net.minecraft.class_747;
import net.minecraft.class_7923;

public class DragonEntity extends class_1314 implements class_1265, class_6025 {

    public static final class_2940<Boolean> IS_FLYING;
    public static final class_2940<Boolean> IS_START_FLYING;
    public static final class_2940<Boolean> CLIENT_START_FLYING;
    public static final class_2940<Boolean> CLIENT_END_FLYING;
    public static final class_2940<Byte> TAMEABLE_FLAGS;
    public static final class_2940<Optional<UUID>> OWNER_UUID;
    public static final class_2940<Boolean> HAS_SADDLE;
    public static final class_2940<Boolean> HAS_CHEST;
    public static final class_2940<Boolean> OTHER_EARS;
    public static final class_2940<Boolean> OTHER_TAIL;
    public static final class_2940<Boolean> OTHER_EYES;
    public static final class_2940<Integer> DRAGON_SIZE;
    public static final class_2940<Boolean> FIRE_BREATH;
    public static final class_2940<Boolean> RED_DRAGON;

    private boolean sitting;
    public boolean isFlying;
    private int startFlyingTimer = 0;
    private float dragonSideSpeed = 0.0F;
    private float dragonForwardSpeed = 0.0F;
    public int keyBind = 342;
    private float turningFloat;
    private boolean hasSaddle;
    private int healingFood;
    private class_1277 inventory;
    private int onGroundTicker;
    private int dragonAge;
    private int dragonAgeFoodBonus;
    private int fireBreathCooldown;
    public boolean fireBreathActive;
    private int startFlyingTime = 0;
    private int fluidTicker = 0;

    @SuppressWarnings("deprecation")
    public DragonEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.onChestedStatusChanged();
        this.method_46396();
        this.field_6194 = 10;
    }

    public static class_5132.class_5133 createDragonAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 60.0D).method_26868(class_5134.field_23721, 9.0D).method_26868(class_5134.field_23719, 0.28D)
                .method_26868(class_5134.field_23724, 6.0D).method_26868(class_5134.field_23718, 0.5D);
    }

    @Override
    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new DragonSitGoal(this));
        this.field_6201.method_6277(2, new DragonFindOwnerGoal(this, 0.1D, 10.0F, 2.0F));
        this.field_6201.method_6277(3, new DragonFlyRandomlyGoal(this));
        this.field_6201.method_6277(4, new class_1379(this, 0.9D));
        this.field_6201.method_6277(5, new class_1361(this, class_1657.class, 10.0F, 0.8F));
        this.field_6201.method_6277(6, new class_1376(this));
    }

    @Override
    protected void method_5693(class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TAMEABLE_FLAGS, (byte) 0);
        builder.method_56912(OWNER_UUID, Optional.empty());
        builder.method_56912(IS_FLYING, false);
        builder.method_56912(CLIENT_END_FLYING, false);
        builder.method_56912(IS_START_FLYING, false);
        builder.method_56912(CLIENT_START_FLYING, false);
        builder.method_56912(HAS_SADDLE, false);
        builder.method_56912(HAS_CHEST, false);
        builder.method_56912(OTHER_EARS, false);
        builder.method_56912(OTHER_TAIL, false);
        builder.method_56912(OTHER_EYES, false);
        builder.method_56912(DRAGON_SIZE, 1);
        builder.method_56912(FIRE_BREATH, false);
        builder.method_56912(RED_DRAGON, false);
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (this.method_6139() != null) {
            tag.method_25927("DragonOwner", this.method_6139());
        }
        tag.method_10556("IsFlying", this.isFlying);
        tag.method_10556("SittingDragon", this.sitting);
        tag.method_10556("HasSaddle", this.hasSaddle);
        tag.method_10556("HasChest", this.hasChest());
        if (this.hasChest()) {
            class_2499 listTag = new class_2499();
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                class_1799 itemStack = this.inventory.method_5438(i);
                if (!itemStack.method_7960()) {
                    class_2487 compoundTag = new class_2487();
                    compoundTag.method_10567("Slot", (byte) i);
                    compoundTag.method_10566("OrcItem", this.inventory.method_5438(0).method_57358(this.method_56673()));
                    listTag.add(compoundTag);
                }
            }
            tag.method_10566("Items", listTag);
        }
        tag.method_10569("DragonSize", this.getSize());
        tag.method_10556("OtherDragonEars", this.method_5841().method_12789(DragonEntity.OTHER_EARS));
        tag.method_10556("OtherDragonTail", this.method_5841().method_12789(DragonEntity.OTHER_TAIL));
        tag.method_10556("OtherDragonEyes", this.method_5841().method_12789(DragonEntity.OTHER_EYES));
        tag.method_10556("RedDragon", this.method_5841().method_12789(DragonEntity.RED_DRAGON));
        tag.method_10569("DragonAge", this.dragonAge);
        tag.method_10569("StartFlyingTime", this.startFlyingTime);
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        UUID uUID2;
        if (tag.method_25928("DragonOwner")) {
            uUID2 = tag.method_25926("DragonOwner");
        } else {
            String string = tag.method_10558("DragonOwner");
            uUID2 = class_3321.method_14546(this.method_5682(), string);
        }
        if (uUID2 != null) {
            try {
                this.setOwnerUuid(uUID2);
                this.setTamed(true);
            } catch (Throwable var4) {
                this.setTamed(false);
            }
        }
        this.isFlying = tag.method_10577("IsFlying");
        this.field_6011.method_12778(IS_FLYING, this.isFlying);
        this.sitting = tag.method_10577("SittingDragon");
        this.setSitting(this.sitting);
        this.hasSaddle = tag.method_10577("HasSaddle");
        this.field_6011.method_12778(HAS_SADDLE, this.hasSaddle);
        this.setHasChest(tag.method_10577("HasChest"));
        if (this.hasChest()) {
            class_2499 listTag = tag.method_10554("Items", 10);
            this.onChestedStatusChanged();

            for (int i = 0; i < listTag.size(); ++i) {
                class_2487 compoundTag = listTag.method_10602(i);
                int j = compoundTag.method_10571("Slot") & 255;
                if (j >= 0 && j < this.inventory.method_5439()) {
                    this.inventory.method_5447(j, class_1799.method_57360(this.method_56673(), compoundTag).get());
                }
            }
        }
        this.setSize(tag.method_10550("DragonSize"));
        this.field_6011.method_12778(OTHER_EARS, tag.method_10577("OtherDragonEars"));
        this.field_6011.method_12778(OTHER_TAIL, tag.method_10577("OtherDragonTail"));
        this.field_6011.method_12778(OTHER_EYES, tag.method_10577("OtherDragonEyes"));
        this.field_6011.method_12778(RED_DRAGON, tag.method_10577("RedDragon"));
        this.dragonAge = tag.method_10550("DragonAge");
        if (this.isFlying) {
            this.startFlyingTime = tag.method_10550("StartFlyingTime");
        }
    }

    @Override
    public void method_6091(class_243 movementInput) {
        if (this.method_5805()) {
            if (this.method_5782() && this.canBeControlledByRider()) {
                class_1309 livingEntity = (class_1309) this.method_5642();
                double wrapper = class_3532.method_15338(this.field_6283 - (double) this.method_36454());
                this.method_36456((float) ((double) this.method_36454() + wrapper));
                this.field_5982 = this.method_36454();
                this.method_36457(livingEntity.method_36455() * 0.5F);
                this.method_5710(this.method_36454(), this.method_36455());
                this.field_6241 = livingEntity.field_6241;
                boolean shouldFlyUp = false;
                boolean shouldFlyDown = false;
                shouldFlyUp = ((LivingEntityAccessor) livingEntity).jumping(); // Pressing jump button for going upwards
                if (this.method_37908().method_8608() && livingEntity instanceof class_746) {
                    class_746 clientPlayerEntity = (class_746) livingEntity;
                    shouldFlyDown = class_3675.method_15987(class_310.method_1551().method_22683().method_4490(), this.keyBind);
                    if (clientPlayerEntity.field_3913.field_3908) {
                        turningFloat -= 0.05F;
                    }
                    if (!clientPlayerEntity.field_3913.field_3908 && turningFloat < 0.0F) {
                        turningFloat = 0.0F;
                    }
                    if (clientPlayerEntity.field_3913.field_3906) {
                        turningFloat += 0.05F;
                    }
                    if (!clientPlayerEntity.field_3913.field_3906 && turningFloat > 0.0F) {
                        turningFloat = 0.0F;
                    }
                }

                this.method_36456(ConfigInit.CONFIG.heavy_dragon_flight ? this.method_36454() + class_3532.method_15393(turningFloat) : livingEntity.method_36454());

                float f = livingEntity.field_6212 * 0.1F;
                float g = livingEntity.field_6250 * 0.5F;
                float flySpeed = 0.0F;
                float maxForwardSpeed = 0.6F;
                float maxSidewaysSpeed = 0.15F;

                if ((this.dragonForwardSpeed < maxForwardSpeed && livingEntity.field_6250 > 0.0F) || (this.dragonForwardSpeed > maxForwardSpeed * -0.3F && livingEntity.field_6250 < 0.0F)) {
                    this.dragonForwardSpeed += g * 0.04F;
                }
                if ((this.dragonSideSpeed < maxSidewaysSpeed && livingEntity.field_6212 > 0.0F) || (this.dragonSideSpeed > maxSidewaysSpeed * -1 && livingEntity.field_6212 < 0.0F)) {
                    this.dragonSideSpeed += f * 0.03F;
                }
                if (livingEntity.field_6212 == 0.0F) {
                    // this.dragonSideSpeed *= 0.7F;
                    this.dragonSideSpeed = 0.0F;
                }
                if (livingEntity.field_6250 == 0.0F) {
                    // this.dragonForwardSpeed *= 0.7F;
                    this.dragonForwardSpeed = 0.0F;
                }

                // To do, set proper sit position
                if (shouldFlyUp && !this.isFlying && this.startFlyingTimer < 10) {
                    if (this.method_5799() && this.method_5861(class_3486.field_15517) > 0.5D) {
                        if (!this.method_37908().method_8608() && this.method_31483() instanceof class_3222) {
                            ServerPlayNetworking.send((class_3222) this.method_31483(), new VelocityPacket(this.method_5628(), 0.05F));
                        }
                    } else {
                        this.startFlyingTimer++;
                        this.method_5841().method_12778(CLIENT_START_FLYING, true);
                        this.method_5841().method_12778(IS_START_FLYING, true);
                    }
                }
                if (!shouldFlyUp && !this.isFlying && this.startFlyingTimer > 0) {
                    this.startFlyingTimer--;
                    this.method_5841().method_12778(IS_START_FLYING, false);
                }
                if ((this.startFlyingTimer <= 0 && !this.isFlying) || this.isFlying || this.method_5841().method_12789(IS_FLYING)) {
                    this.method_5841().method_12778(CLIENT_START_FLYING, false);
                }

                if (this.startFlyingTimer >= 10 && (!this.isFlying || !this.method_5841().method_12789(IS_FLYING))) {
                    this.isFlying = true;
                    this.method_5841().method_12778(IS_FLYING, true);
                    this.startFlyingTimer = 0;
                    this.startFlyingTime = (int) this.method_37908().method_8510();
                }
                if (this.isFlying && this.method_24828()) {// && shouldFlyDown only client: bad
                    this.onGroundTicker++;
                    if (this.onGroundTicker > 3) {
                        this.onGroundTicker = 0;
                        this.isFlying = false;
                        this.method_5841().method_12778(IS_FLYING, false);
                        this.method_5841().method_12778(CLIENT_END_FLYING, true);
                    }

                }
                if ((this.isFlying || this.method_5841().method_12789(IS_FLYING)) && shouldFlyUp) {
                    flySpeed = 0.15F;
                }
                if ((this.isFlying || this.method_5841().method_12789(IS_FLYING)) && shouldFlyDown) {
                    flySpeed = -0.2F;
                }
                if ((this.isFlying || this.method_5841().method_12789(IS_FLYING)) && !shouldFlyDown && !shouldFlyUp) {
                    flySpeed *= 0.4F;
                }

                if (this.method_5787()) {
                    this.method_6125((float) this.method_45325(class_5134.field_23719));
                    if ((!this.method_5841().method_12789(IS_FLYING) && !this.isFlying) || (this.method_5799() && this.method_5861(class_3486.field_15517) > 0.2D)) {
                        super.method_6091(new class_243((double) f, movementInput.field_1351, (double) g));
                    } else {
                        class_243 vec3d;
                        if (ConfigInit.CONFIG.heavy_dragon_flight)
                            vec3d = new class_243((double) this.dragonSideSpeed, movementInput.field_1351 + flySpeed, (double) this.dragonForwardSpeed);
                        else {
                            vec3d = new class_243(livingEntity.field_6212 * 0.7D, movementInput.field_1351 + flySpeed, livingEntity.field_6250 * 0.7D);
                        }
                        // vec3d x,y,z
                        // x is used when left or right key
                        // z is used when forward or backward
                        if (this.method_18798().method_37267() > 0.01D) {
                            if (vec3d.method_10215() < 0.001D && vec3d.method_10215() > -0.001D) {
                                this.method_18799(this.method_18798().method_1021(0.95D));
                            }
                        }
                        this.method_5724(0.05F, vec3d);
                        this.method_5784(class_1313.field_6308, this.method_18798());
                        this.method_18799(this.method_18798());
                    }
                } else if (livingEntity instanceof class_1657) {
                    this.method_18799(class_243.field_1353);
                }
                this.method_29242(false);
            } else {
                if (this.isFlying || this.method_5841().method_12789(IS_FLYING)) {
                    this.method_5724(0.03F, movementInput);
                    this.method_5784(class_1313.field_6308, this.method_18798());
                    this.method_18799(this.method_18798().method_1021((0.91F)));
                    double wrapper = class_3532.method_15338(this.field_6241 - (double) this.method_36454());
                    this.method_36456((float) ((double) this.method_36454() + wrapper));
                    class_2338 blockPos = this.method_24515().method_10087(2);
                    if (this.method_37908().method_8320(blockPos).method_26212(this.method_37908(), blockPos)) {
                        this.method_18799(this.method_18798().method_1031(0.0D, -0.005D, 0.0D));
                    }
                    if (this.method_24828()) {
                        this.method_5841().method_12778(CLIENT_END_FLYING, true);
                        this.isFlying = false;
                        this.method_5841().method_12778(IS_FLYING, false);
                    }
                } else {
                    super.method_6091(movementInput);
                }
            }
        }
        if (this.isFlying && this.startFlyingTime != 0 && (int) (this.method_37908().method_8510() - this.startFlyingTime) % 25 == 0) {
            this.playWingFlapSound();
        }

    }

    private boolean canBeControlledByRider() {
        return this.method_5642() instanceof class_1309;
    }

    @Override
    public boolean method_6101() {
        return false;
    }

    @Override
    public boolean method_32316() {
        return false;
    }

    @Override
    @Nullable
    public class_1309 method_5642() {
        return !this.method_5685().isEmpty() && this.method_5685().get(0) instanceof class_1309 ? (class_1309) this.method_5685().get(0) : null;
    }

    @Nullable
    private class_243 method_27930(class_243 vec3d, class_1309 livingEntity) {
        double d = this.method_23317() + vec3d.field_1352;
        double e = this.method_5829().field_1322;
        double f = this.method_23321() + vec3d.field_1350;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        UnmodifiableIterator<class_4050> var10 = livingEntity.method_24831().iterator();

        while (var10.hasNext()) {
            class_4050 entityPose = (class_4050) var10.next();
            mutable.method_10102(d, e, f);
            double g = this.method_5829().field_1325 + 0.75D;

            while (true) {
                double h = this.method_37908().method_30347(mutable);
                if ((double) mutable.method_10264() + h > g) {
                    break;
                }

                if (class_5275.method_27932(h)) {
                    class_238 box = livingEntity.method_24833(entityPose);
                    class_243 vec3d2 = new class_243(d, (double) mutable.method_10264() + h, f);
                    if (class_5275.method_27933(this.method_37908(), livingEntity, box.method_997(vec3d2))) {
                        livingEntity.method_18380(entityPose);
                        return vec3d2;
                    }
                }

                mutable.method_10098(class_2350.field_11036);
                if ((double) mutable.method_10264() >= g) {
                    break;
                }
            }
        }

        return null;
    }

    @Override
    public class_243 method_24829(class_1309 passenger) {
        class_243 vec3d = method_24826((double) this.method_17681(), (double) passenger.method_17681(), this.method_36454() + (passenger.method_6068() == class_1306.field_6183 ? 90.0F : -90.0F));
        class_243 vec3d2 = this.method_27930(vec3d, passenger);
        if (vec3d2 != null) {
            return vec3d2;
        } else {
            class_243 vec3d3 = method_24826((double) this.method_17681(), (double) passenger.method_17681(), this.method_36454() + (passenger.method_6068() == class_1306.field_6182 ? 90.0F : -90.0F));
            class_243 vec3d4 = this.method_27930(vec3d3, passenger);
            return vec3d4 != null ? vec3d4 : this.method_19538();
        }
    }

    private void putPlayerOnBack(class_1657 player) {
        if (!this.method_37908().method_8608()) {
            player.method_36456(this.method_36454());
            player.method_36457(this.method_36455());
            player.method_5804(this);
        }
    }

    public void dragonFireBreath() {
        if (this.fireBreathCooldown <= 60) {
            this.fireBreathCooldown++;
            if (!this.method_37908().method_8608()) {
                if (this.fireBreathCooldown == 1) {
                    this.method_37908().method_43129((class_1657) null, this, SoundInit.DRAGON_BREATH_EVENT, class_3419.field_15251, 1.0F, 1.0F);
                }
                if (this.fireBreathCooldown % 3 == 0) {
                    class_243 vec3d = this.method_5631(field_6004, field_6241);
                    class_243 otherVec3d = this.method_5631(field_6004, field_6283);
                    vec3d = vec3d.method_1019(otherVec3d);
                    FireBreathEntity fireBreathEntity = new FireBreathEntity(this.method_37908(), this, vec3d);
                    fireBreathEntity.method_5808(this.method_23317() + vec3d.field_1352 * 3D,
                            this.method_23318() + this.method_5829().method_17940() * 0.65D + (this.method_36455() > 0F ? -this.method_36455() / 40F : -this.method_36455() / 80F), this.method_23321() + vec3d.field_1350 * 3D,
                            this.method_36454(), this.method_36455());

                    this.method_37908().method_8649(fireBreathEntity);
                }
            } else {
                if (!this.method_5841().method_12789(FIRE_BREATH)) {
                    this.method_5841().method_12778(FIRE_BREATH, true);
                }
            }
        } else {
            this.fireBreathActive = false;
        }
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        if (!this.method_6109() && this.method_5782())
            return super.method_5992(player, hand);

        if (this.method_37908().method_8608()) {
            boolean bl = this.isOwner(player) || this.isTamed() || this.dragonFood(item) && !this.isTamed();
            return bl ? class_1269.field_21466 : class_1269.field_5811;
        } else {
            // Check for owner
            if (this.isTamed() && this.getSize() > 1 && this.isOwner(player)) {
                if (item == class_1802.field_8106 && !this.hasChest() && this.getSize() > 2) {
                    this.method_37908().method_43129((class_1657) null, this, SoundInit.EQUIP_CHEST_EVENT, class_3419.field_15254, 0.5F, 1.0F);
                    this.setHasChest(true);
                    if (!player.method_7337()) {
                        itemStack.method_7934(1);
                    }
                    return class_1269.field_5812;
                }
                if (this.dragonFood(item) && this.method_6032() < this.method_6063() && player.method_5715()) {
                    if (!player.method_7337()) {
                        itemStack.method_7934(1);
                    }
                    this.method_6025((float) this.healingFood);
                    return class_1269.field_5812;
                } else if (!player.method_5715()) {
                    if (!this.hasSaddle) {
                        if (item == ItemInit.DRAGON_SADDLE) {
                            this.method_37908().method_43129((class_1657) null, this, class_3417.field_14704, class_3419.field_15254, 0.8F, 1.0F);
                            if (!player.method_7337()) {
                                itemStack.method_7934(1);
                            }
                            this.hasSaddle = true;
                            this.method_5841().method_12778(HAS_SADDLE, true);
                            return class_1269.field_5812;
                        }
                        return class_1269.field_5814;
                    }
                    this.setSitting(false);
                    this.putPlayerOnBack(player);
                    return class_1269.field_5812;
                } else if (this.isInSittingPose()) {
                    this.setSitting(false);
                    return class_1269.field_5812;
                } else if (this.method_24828()) {
                    this.setSitting(true);
                    return class_1269.field_5812;
                } else
                    return class_1269.field_5811;
            } else if (this.dragonFood(item)) {
                if (!this.isTamed()) {
                    if (!player.method_7337()) {
                        itemStack.method_7934(1);
                    }
                    int tamer;
                    if (item == ItemInit.ORC_SKIN) {
                        tamer = 1;
                    } else {
                        tamer = healingFood;
                    }
                    if (this.field_5974.method_43048(tamer) == 0) {
                        this.setOwner(player);
                        this.field_6189.method_6340();
                        this.method_5980((class_1309) null);
                        this.method_37908().method_8421(this, (byte) 7);
                    } else {
                        this.method_37908().method_8421(this, (byte) 6);
                    }

                    return class_1269.field_5812;
                } else {
                    if (this.canEatFood(this.dragonAge, 3, 13)) {
                        if (!player.method_7337()) {
                            itemStack.method_7934(1);
                        }
                        dragonAgeFoodBonus++;
                        return class_1269.field_5812;
                    } else {
                        return class_1269.field_5811;
                    }

                }
            }

            return super.method_5992(player, hand);
        }
    }

    private boolean dragonFood(class_1792 item) {
        if (item == ItemInit.ORC_SKIN) {
            healingFood = 6;
            return true;
        } else if (item == class_1802.field_8389 || item == class_1802.field_8046 || item == ItemInit.MAMMOTH_MEAT || item == ItemInit.RAW_VENISON || item == ItemInit.RHINO_MEAT || item == ItemInit.WARTHOG_MEAT
                || item == ItemInit.ENDER_WHALE_MEAT) {
            healingFood = 5;
            return true;
        } else if (item == class_1802.field_8748 || item == class_1802.field_8726 || item == ItemInit.IGUANA_MEAT) {
            healingFood = 4;
            return true;
        } else if (item == class_1802.field_8504) {
            healingFood = 3;
            return true;
        }
        return false;
    }

    private boolean canEatFood(int age, int minAge, int maxAge) {
        if (age < minAge || (age < maxAge && age > maxAge - (minAge * 2))) {
            return true;
        } else
            return false;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            if (this.getSize() < 3) {
                if (this.field_6012 % 1200 == 0) {
                    this.dragonAge++;
                }
                if (this.dragonAge == 5 && this.getSize() == 1) {
                    this.setSize(2);
                    this.healDragonIfGrowing();
                }
                if (this.dragonAge == 15 && this.getSize() == 2) {
                    this.setSize(3);
                    this.healDragonIfGrowing();
                }
                if (this.dragonAgeFoodBonus > 5) {
                    this.dragonAgeFoodBonus = 0;
                    this.dragonAge++;
                    this.method_37908().method_8421(this, (byte) 9);
                }
            }
            if (this.method_5799() || this.method_5771()) {
                if (this.isFlying && this.method_5861(class_3486.field_15517) > 1.2D) {
                    this.fluidTicker++;
                    if (this.fluidTicker >= 30) {
                        this.isFlying = false;
                        this.method_5841().method_12778(IS_FLYING, false);
                        this.method_5841().method_12778(IS_START_FLYING, false);
                        this.method_5841().method_12778(CLIENT_START_FLYING, false);
                        this.method_5841().method_12778(CLIENT_END_FLYING, false);
                        this.startFlyingTimer = 0;
                        this.fluidTicker = 0;
                    }
                } else if (this.method_37908().method_8608() && this.method_5782() && !this.isFlying && this.method_5861(class_3486.field_15517) > 1.0D) {
                    this.method_5762(0.0D, 0.05D, 0.0D);
                }
            } else if (this.fluidTicker != 0)
                this.fluidTicker = 0;
        }

        if (this.fireBreathCooldown > 60) {
            this.fireBreathCooldown++;
            if (this.method_5841().method_12789(FIRE_BREATH)) {
                this.method_5841().method_12778(FIRE_BREATH, false);
            }
            if (this.fireBreathCooldown >= 120) {
                this.fireBreathCooldown = 0;
            }
        }
        if (this.fireBreathActive) {
            this.dragonFireBreath();
        }
    }

    private void healDragonIfGrowing() {
        if (this.method_6032() < this.method_6063()) {
            this.method_6033(this.method_6032() + 20F);
        }
    }

    @Override
    public boolean method_5810() {
        return !this.method_5782();
    }

    @Override
    public boolean method_5931() {
        return !this.method_60953();
    }

    @Environment(EnvType.CLIENT)
    protected void showEmoteParticle(boolean positive) {
        class_2394 particleEffect = class_2398.field_11201;
        if (!positive) {
            particleEffect = class_2398.field_11251;
        }

        for (int i = 0; i < 7; ++i) {
            double d = this.field_5974.method_43059() * 0.02D;
            double e = this.field_5974.method_43059() * 0.02D;
            double f = this.field_5974.method_43059() * 0.02D;
            this.method_37908().method_8406(particleEffect, this.method_23322(1.0D), this.method_23319() + 0.5D, this.method_23325(1.0D), d, e, f);
        }

    }

    @Override
    @Environment(EnvType.CLIENT)
    public void method_5711(byte status) {
        if (status == 7 || status == 9) {
            this.showEmoteParticle(true);
        } else if (status == 6) {
            this.showEmoteParticle(false);
        } else {
            super.method_5711(status);
        }

    }

    public boolean isTamed() {
        return ((Byte) this.field_6011.method_12789(TAMEABLE_FLAGS) & 4) != 0;
    }

    public void setTamed(boolean tamed) {
        byte b = (Byte) this.field_6011.method_12789(TAMEABLE_FLAGS);
        if (tamed) {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (byte) (b | 4));
        } else {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (byte) (b & -5));
        }
    }

    @Nullable
    @Override
    public UUID method_6139() {
        return (UUID) ((Optional<UUID>) this.field_6011.method_12789(OWNER_UUID)).orElse((UUID) (Object) null);
    }

    public void setOwnerUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void setOwner(class_1657 player) {
        this.setTamed(true);
        this.setOwnerUuid(player.method_5667());
    }

    @Nullable
    @Override
    public class_1309 method_35057() {
        try {
            UUID uUID = this.method_6139();
            return uUID == null ? null : this.method_37908().method_18470(uUID);
        } catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Override
    public boolean method_18395(class_1309 target) {
        return this.isOwner(target) ? false : super.method_18395(target);
    }

    public boolean isOwner(class_1309 entity) {
        return entity == this.method_35057();
    }

    @Override
    public boolean method_5722(class_1297 other) {
        if (this.isTamed()) {
            class_1309 livingEntity = this.method_35057();
            if (other == livingEntity) {
                return true;
            }

            if (livingEntity != null) {
                return livingEntity.method_5722(other);
            }
        }

        return super.method_5722(other);
    }

    @Override
    public void method_6078(class_1282 source) {
        if (!this.method_37908().method_8608()) {
            if (this.method_37908().method_8450().method_8355(class_1928.field_19398) && this.method_35057() instanceof class_3222) {
                this.method_35057().method_43496(this.method_6066().method_5548());
            }
            if (FabricLoader.getInstance().isModLoaded("dragonloot")) {
                this.method_5775(new class_1799(class_7923.field_41178.method_10223(class_2960.method_60655("dragonloot", "dragon_scale")), (int) (this.getSize() * this.method_37908().method_8409().method_43057())));
            }
        }

        super.method_6078(source);
    }

    public boolean isInSittingPose() {
        return ((Byte) this.field_6011.method_12789(TAMEABLE_FLAGS) & 1) != 0;
    }

    private void setInSittingPose(boolean inSittingPose) {
        this.sitting = inSittingPose;
        byte b = (Byte) this.field_6011.method_12789(TAMEABLE_FLAGS);
        if (inSittingPose) {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (byte) (b | 1));
        } else {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (byte) (b & 0xFFFFFFFE));
        }

    }

    public void setSitting(boolean sitting) {
        this.sitting = sitting;
        setInSittingPose(sitting);
    }

    @Override
    public int method_5978() {
        if (this.isInSittingPose()) {
            return 20;
        }
        return super.method_5978();
    }

    @Override
    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    @Override
    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
        if (!this.method_37908().method_8608() && !this.isFlying && !onGround && heightDifference < -0.7D) {
            if (this.sitting)
                this.setSitting(false);
            if (!this.method_5782()) {
                this.isFlying = true;
                this.method_5841().method_12778(IS_FLYING, true);
                this.method_5841().method_12778(IS_START_FLYING, false);
                this.method_5841().method_12778(CLIENT_START_FLYING, false);
                this.startFlyingTime = (int) this.method_37908().method_8510();
            }
        }
        super.method_5623(heightDifference, onGround, landedState, landedPosition);
    }

    private void playWingFlapSound() {
        this.method_37908().method_43129(null, this, class_3417.field_14550, this.method_5634(), 5.0f, 0.8f + this.field_5974.method_43057() * 0.3f);
    }

    public void setKeyBind(String key) {
        this.keyBind = class_3675.method_15981(key).method_1444();
    }

    @Override
    protected class_3414 method_5994() {
        return SoundInit.DRAGON_IDLE_EVENT;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return SoundInit.DRAGON_HIT_EVENT;
    }

    @Override
    protected class_3414 method_6002() {
        return SoundInit.DRAGON_DEATH_EVENT;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(SoundInit.DRAGON_STEP_EVENT, 0.7F, 1.0F);
    }

    @Override
    protected float method_5867() {
        return (float) ((int) this.field_5994 + 2) - 0.01F;
    }

    @Override
    public boolean method_5974(double num) {
        return false;
    }

    @Override
    public void method_5453(class_1263 sender) {
    }

    private void onChestedStatusChanged() {
        class_1277 simpleInventory = this.inventory;
        this.inventory = new class_1277(27);
        if (simpleInventory != null) {
            simpleInventory.method_5488(this);
            int i = Math.min(simpleInventory.method_5439(), this.inventory.method_5439());

            for (int j = 0; j < i; ++j) {
                class_1799 itemStack = simpleInventory.method_5438(j);
                if (!itemStack.method_7960()) {
                    this.inventory.method_5447(j, itemStack.method_7972());
                }
            }
        }

        this.inventory.method_5489(this);
    }

    @Override
    protected void method_16078() {
        super.method_16078();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                class_1799 itemStack = this.inventory.method_5438(i);
                if (!itemStack.method_7960()) {
                    this.method_5775(itemStack);
                }
            }

        }
        if (this.hasChest()) {
            if (!this.method_37908().method_8608()) {
                this.method_5706(class_2246.field_10034);
            }

            this.setHasChest(false);
        }
    }

    public boolean hasChest() {
        return (Boolean) this.field_6011.method_12789(HAS_CHEST);
    }

    public void setHasChest(boolean hasChest) {
        this.field_6011.method_12778(HAS_CHEST, hasChest);
    }

    public void openInventory(class_1657 player) {
        if (!this.method_37908().method_8608() && (!this.method_5782() || this.method_5626(player)) && this.isTamed()) {
            player.method_17355(new class_747(
                    (syncId, inv, p) -> new class_1707(class_3917.field_17326, syncId, p.method_31548(), this.inventory, 27 / 9), this.method_5477()));
        }

    }

    @Nullable
    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.method_5841().method_12778(OTHER_EARS, world.method_8409().method_43056());
        this.method_5841().method_12778(OTHER_TAIL, world.method_8409().method_43056());
        this.method_5841().method_12778(OTHER_EYES, world.method_8409().method_43056());
        if (world.method_8597().comp_644())
            this.method_5841().method_12778(RED_DRAGON, world.method_8409().method_43056());
        if (spawnReason.equals(class_3730.field_16462)) {
            this.setSize(3);
        } else {
            this.setSize(1);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected class_4048 method_55694(class_4050 pose) {
        return super.method_55694(pose).method_18383((float) this.getSize() / 3.0F);
    }

    public int getSize() {
        return (Integer) this.field_6011.method_12789(DRAGON_SIZE);
    }

    public void setSize(int size) {
        this.field_6011.method_12778(DRAGON_SIZE, size);
        this.method_23311();
        this.method_18382();
        this.method_5996(class_5134.field_23716).method_6192((double) (size * 20));
        this.method_5996(class_5134.field_23721).method_6192((double) size * 3);
        this.method_5996(class_5134.field_23724).method_6192((double) size * 2);
    }

    @Override
    public void method_5674(class_2940<?> data) {
        if (DRAGON_SIZE.equals(data)) {
            this.method_18382();
            this.method_36456(this.field_6241);
            this.method_5636(this.field_6241);
        }
        super.method_5674(data);
    }

    @Override
    public void method_18382() {
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        super.method_18382();
        this.method_30634(d, e, f);
    }

    @Override
    protected float method_6107() {
        return 0.3F * (float) this.getSize();
    }

    @Override
    public float method_6017() {
        return 1.6F - ((float) 0.2F * this.getSize());
    }

    // @Override
    // protected float getActiveEyeHeight(EntityPose pose, EntityDimensions dimensions) {
    // if (this.getSize() == 1) {
    // return 0.80F * dimensions.height;
    // }
    // return 0.85F * dimensions.height;
    // }

    // @Override
    // public double getMountedHeightOffset() {
    // double flySubtraction = 0.92D;
    // if (this.isFlying) {
    // flySubtraction = 0.9D;
    // }
    // return (double) this.getSize() * 0.794 * flySubtraction;
    // }

    @Override
    protected void method_5865(class_1297 passenger, class_4738 positionUpdater) {
        // public void updatePassengerPosition(Entity passenger) {
        // super.updatePassengerPosition(passenger);
        super.method_5865(passenger, positionUpdater);
        if (passenger instanceof class_1308) {
            class_1308 mobEntity = (class_1308) passenger;
            this.field_6283 = mobEntity.field_6283;
            // float slowlyIncreasingFloat = ((float) Math.floorMod(this.getWorld().getTime(), 100L) + animationProgress) / 100.0F;
            // float mediumSpeedSin = MathHelper.cos(12.566370614F * slowlyIncreasingFloat );
            // float bodyFloating = -mediumSpeedSin - 4.0F;
            // this.body.pivotY = bodyFloating;
            if (this.method_37908().method_8608()) {
                float offSet = 12F;
                if (passenger.equals(this.method_5642())) {
                    offSet = 1F;
                }
                float f = class_3532.method_15374(this.field_6283 * 0.017453292F) * offSet;
                float g = class_3532.method_15362(this.field_6283 * 0.017453292F) * offSet;

                passenger.method_5814(this.method_23317() + (double) (0.1F * f), this.method_23323(0.66F), this.method_23321() - (double) (0.1F * g));
                // passenger.setPosition(this.getX() + (double) (0.1F * f), this.getBodyY(0.66F) + passenger.getHeightOffset(), this.getZ() - (double) (0.1F * g));
            }
        }

    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_48789(TagInit.IS_WALL)) {
            return false;
        }
        if (!this.method_37908().method_8608()) {
            this.setSitting(false);
        }
        return !this.method_5679(source) && super.method_5643(source, amount);
    }

    static {
        IS_FLYING = class_2945.method_12791(DragonEntity.class, class_2943.field_13323);
        IS_START_FLYING = class_2945.method_12791(DragonEntity.class, class_2943.field_13323);
        CLIENT_START_FLYING = class_2945.method_12791(DragonEntity.class, class_2943.field_13323);
        CLIENT_END_FLYING = class_2945.method_12791(DragonEntity.class, class_2943.field_13323);
        TAMEABLE_FLAGS = class_2945.method_12791(DragonEntity.class, class_2943.field_13319);
        OWNER_UUID = class_2945.method_12791(DragonEntity.class, class_2943.field_13313);
        HAS_SADDLE = class_2945.method_12791(DragonEntity.class, class_2943.field_13323);
        HAS_CHEST = class_2945.method_12791(DragonEntity.class, class_2943.field_13323);
        OTHER_EARS = class_2945.method_12791(DragonEntity.class, class_2943.field_13323);
        OTHER_TAIL = class_2945.method_12791(DragonEntity.class, class_2943.field_13323);
        OTHER_EYES = class_2945.method_12791(DragonEntity.class, class_2943.field_13323);
        DRAGON_SIZE = class_2945.method_12791(DragonEntity.class, class_2943.field_13327);
        FIRE_BREATH = class_2945.method_12791(DragonEntity.class, class_2943.field_13323);
        RED_DRAGON = class_2945.method_12791(DragonEntity.class, class_2943.field_13323);
    }

    @Environment(EnvType.CLIENT)
    public static void flyDragonDown(class_746 player, String keyString) {
        if (player.method_5854() != null && player.method_5854() instanceof DragonEntity)
            ((DragonEntity) player.method_5854()).setKeyBind(keyString);
    }

    @Environment(EnvType.CLIENT)
    public static void dragonFireBreath(class_746 player) {
        if (player.method_5854() != null && player.method_5854() instanceof DragonEntity dragonEntity && player.method_5854().method_5805()) {
            if (dragonEntity.method_5841().method_12789(DragonEntity.DRAGON_SIZE) >= 3) {
                ClientPlayNetworking.send(new DragonFireBreathPacket());
                ((DragonEntity) player.method_5854()).fireBreathActive = true;
            }
        }
    }

}
