package net.adventurez.entity;

import java.util.EnumSet;

import com.google.common.collect.UnmodifiableIterator;

import org.jetbrains.annotations.Nullable;

import net.adventurez.init.EntityInit;
import net.adventurez.init.ItemInit;
import net.adventurez.init.SoundInit;
import net.adventurez.mixin.accessor.EntityAccessor;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1307;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1510;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2945.class_9222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4980;
import net.minecraft.class_4981;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5275;
import net.minecraft.class_5819;

public class EnderWhaleEntity extends class_1307 implements class_4981 {

    private static final class_2940<Boolean> ALWAYS_SADDLED;
    private static final class_2940<Integer> BOOST_TIME;
    private final class_4980 saddledComponent;

    public EnderWhaleEntity(class_1299<? extends class_1307> entityType, class_1937 world) {
        super(entityType, world);
        this.saddledComponent = new class_4980(this.field_6011, BOOST_TIME, ALWAYS_SADDLED);
        this.field_6207 = new EnderWhaleEntity.EnderWhaleMovementControl(this);
        this.field_6194 = 5;
    }

    public static class_5132.class_5133 createEnderWhaleAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 60.0D).method_26868(class_5134.field_23719, 0.022D).method_26868(class_5134.field_23721, 7.0D)
                .method_26868(class_5134.field_23722, 1.5D).method_26868(class_5134.field_23718, 2.5D);
    }

    public static boolean canSpawn(class_1299<EnderWhaleEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        class_2680 blockState = world.method_8320(pos);
        return random.method_43048(6) == 0 && pos.method_10264() > 40 && pos.method_10264() - world.method_8598(class_2902.class_2903.field_13202, pos).method_10264() > 20 && blockState.method_26215()
                && world.method_8390(class_1510.class, new class_238(pos).method_1014(80D), class_1301.field_6155).isEmpty()
                && class_1948.method_8662(world, pos, blockState, blockState.method_26227(), EntityInit.ENDER_WHALE);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(5, new EnderWhaleEntity.FlyRandomlyGoal(this));
        this.field_6201.method_6277(4, new EnderWhaleEntity.TemptGoal(this, 1.2D, class_1856.method_8091(ItemInit.CHORUS_FRUIT_ON_A_STICK)));
        this.field_6201.method_6277(7, new EnderWhaleEntity.LookWhereToFlyGoal(this));
    }

    @Override
    protected void method_5693(class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ALWAYS_SADDLED, true);
        builder.method_56912(BOOST_TIME, 0);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.saddledComponent.method_26309(nbt);
    }

    @Override
    public boolean method_5931() {
        return false;
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.saddledComponent.method_26312(nbt);
    }

    @Override
    protected boolean method_5818(class_1297 passenger) {
        return this.method_5685().size() < 2;
    }

    @Override
    @Nullable
    public class_1309 method_5642() {
        return !this.method_5685().isEmpty() && this.method_5685().get(0) instanceof class_1657
                && ((class_1657) this.method_5685().get(0)).method_6047().method_31574(ItemInit.CHORUS_FRUIT_ON_A_STICK) ? (class_1309) this.method_5685().get(0) : null;
    }

    // Not used since it is a flying entity which overrides the travel method and doesn't use movementspeed
    @Override
    protected float method_49485(class_1657 controllingPlayer) {
        return (float) this.method_45325(class_5134.field_23719) * this.saddledComponent.method_49479();
    }

    @Override
    protected class_3414 method_5994() {
        return SoundInit.WHALE_IDLE_EVENT;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return SoundInit.WHALE_HURT_EVENT;
    }

    @Override
    protected class_3414 method_6002() {
        return SoundInit.WHALE_DEATH_EVENT;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    @Override
    protected float method_6107() {
        return 1.1F;
    }

    @Override
    public int method_5970() {
        return 500;
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!player.method_21823()) {
            if ((player.method_5998(hand).method_31574(class_1802.field_8233) || player.method_5998(hand).method_31574(class_1802.field_8882)) && this.method_6063() - this.method_6032() > 0.1F) {
                if (!this.method_37908().method_8608() && !player.method_7337()) {
                    player.method_5998(hand).method_7934(1);
                    this.method_6025(4F);
                }
                return class_1269.method_29236(this.method_37908().method_8608());
            }
            if (!this.method_5782()) {
                if (!this.method_37908().method_8608()) {
                    player.method_5804(this);
                }
                return class_1269.method_29236(this.method_37908().method_8608());
            } else if (((EntityAccessor) this).getPassengerList().size() < 2) {
                if (!this.method_37908().method_8608()) {
                    player.method_5873(this, true);
                }
                return class_1269.method_29236(this.method_37908().method_8608());
            }
        }
        return class_1269.field_5811;
    }

    @Override
    public class_243 method_24829(class_1309 passenger) {
        class_2350 direction = this.method_5755();
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return super.method_24829(passenger);
        } else {
            int[][] is = class_5275.method_27934(direction);
            class_2338 blockPos = this.method_24515();
            class_2338.class_2339 mutable = new class_2338.class_2339();
            UnmodifiableIterator<class_4050> var6 = passenger.method_24831().iterator();

            while (var6.hasNext()) {
                class_4050 entityPose = (class_4050) var6.next();
                class_238 box = passenger.method_24833(entityPose);
                int[][] var9 = is;
                int var10 = is.length;

                for (int var11 = 0; var11 < var10; ++var11) {
                    int[] js = var9[var11];
                    mutable.method_10103(blockPos.method_10263() + js[0], blockPos.method_10264(), blockPos.method_10260() + js[1]);
                    double d = this.method_37908().method_30347(mutable);
                    if (class_5275.method_27932(d)) {
                        class_243 vec3d = class_243.method_26410(mutable, d);
                        if (class_5275.method_27933(this.method_37908(), passenger, box.method_997(vec3d))) {
                            passenger.method_18380(entityPose);
                            return vec3d;
                        }
                    }
                }
            }

            return super.method_24829(passenger);
        }
    }

    // movementInput is somehow affected when ridden otherwise 0,0,0
    @Override
    public void method_6091(class_243 movementInput) {
        if (this.method_5642() != null) {
            if (this.method_5787()) {
                this.method_5724(this.method_6029(), movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021(0.91f));
            }
            this.method_29242(false);
        } else {
            super.method_6091(movementInput);
        }
    }

    // movementInput is Vec3d(this.sidewaysSpeed, this.upwardSpeed, this.forwardSpeed) of the whale entity
    // getControlledMovementInput used in method travelControlled()
    // which will execute travel() method
    @Override
    protected class_243 method_49482(class_1657 controllingPlayer, class_243 movementInput) {
        return new class_243(0.0f, controllingPlayer.method_36455() / 180f * -1f, 1.0f);
    }

    @Override
    protected void method_49481(class_1657 controllingPlayer, class_243 movementInput) {
        super.method_49481(controllingPlayer, movementInput);
        this.method_5710(controllingPlayer.method_36454(), controllingPlayer.method_36455() * 0.5f);
        this.field_6283 = this.field_6241 = this.method_36454();
        this.field_5982 = this.field_6241;
        this.saddledComponent.method_49478();
    }

    @Override
    public boolean method_6577() {
        return this.saddledComponent.method_26308(this.method_59922());
    }

    @Override
    protected void method_5865(class_1297 passenger, class_4738 positionUpdater) {
        if (!this.method_5626(passenger)) {
            return;
        }
        float offSet = 12F;
        if (passenger.equals(this.method_31483())) {
            offSet = 1F;
        }
        float f = class_3532.method_15374(this.field_6283 * 0.017453292F) * offSet;
        float g = class_3532.method_15362(this.field_6283 * 0.017453292F) * offSet;

        positionUpdater.accept(passenger, this.method_23317() + (double) (0.1F * f), this.method_23323(0.68F), this.method_23321() - (double) (0.1F * g));
    }

    @Override
    public boolean method_5810() {
        return false;
    }

    private static class EnderWhaleMovementControl extends class_1335 {
        private final EnderWhaleEntity enderWhaleEntity;
        private int collisionCheckCooldown;
        private int waitCooldown;

        public EnderWhaleMovementControl(EnderWhaleEntity enderWhaleEntity) {
            super(enderWhaleEntity);
            this.enderWhaleEntity = enderWhaleEntity;
        }

        @Override
        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                if (this.collisionCheckCooldown-- <= 0) {
                    this.collisionCheckCooldown += 3;
                    class_243 vec3d = new class_243(this.field_6370 - this.enderWhaleEntity.method_23317(), this.field_6369 - this.enderWhaleEntity.method_23318(), this.field_6367 - this.enderWhaleEntity.method_23321());
                    // Normalize vector
                    double d = Math.sqrt(vec3d.field_1352 * vec3d.field_1352 + vec3d.field_1351 * vec3d.field_1351 + vec3d.field_1350 * vec3d.field_1350);
                    vec3d = new class_243(vec3d.field_1352 / d, vec3d.field_1351 / d, vec3d.field_1350 / d);
                    if ((!this.willCollide() && d > 1) || (this.waitCooldown++ < 0 && d > 1)) {
                        this.enderWhaleEntity.method_18799(vec3d.method_1021(0.12));
                    } else {
                        this.field_6374 = class_1335.class_1336.field_6377;
                        if (this.waitCooldown++ >= 200) {
                            this.waitCooldown = -40;
                        }
                    }
                }
            }
        }

        private boolean willCollide() {
            class_238 box = this.enderWhaleEntity.method_5829();
            box = box.method_1014(0.2D);
            if (this.enderWhaleEntity.method_37908().method_8587(this.enderWhaleEntity, box)) {
                return false;
            }
            return true;
        }
    }

    private static class FlyRandomlyGoal extends class_1352 {
        private final EnderWhaleEntity enderWhaleEntity;

        public FlyRandomlyGoal(EnderWhaleEntity enderWhaleEntity) {
            this.enderWhaleEntity = enderWhaleEntity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        @Override
        public boolean method_6264() {
            class_1335 moveControl = this.enderWhaleEntity.method_5962();
            if (!moveControl.method_6241()) {
                return true;
            } else {
                return false;
            }
        }

        @Override
        public boolean method_6266() {
            return false;
        }

        @Override
        public void method_6269() {
            class_5819 random = this.enderWhaleEntity.method_59922();
            double randomX = 48D + (random.method_43058() * 2.0D - 1.0D) * 128.0D;
            double randomZ = 48D + (random.method_43058() * 2.0D - 1.0D) * 128.0D;

            double d = this.enderWhaleEntity.method_23317() + randomX;
            double e = this.enderWhaleEntity.method_23318() + (double) ((random.method_43058() * 2.0F - 1.0F) * 16.0F);
            double f = this.enderWhaleEntity.method_23321() + randomZ;

            if (this.enderWhaleEntity.method_23318() < 40D)
                e = this.enderWhaleEntity.method_23318() + 16D * random.method_43058();
            else if (this.enderWhaleEntity.method_23318() > 100)
                e = this.enderWhaleEntity.method_23318() - 16D * random.method_43058();

            this.enderWhaleEntity.method_5962().method_6239(d, e, f, 1.0D);
        }
    }

    private static class LookWhereToFlyGoal extends class_1352 {
        private final EnderWhaleEntity enderWhaleEntity;

        public LookWhereToFlyGoal(EnderWhaleEntity enderWhaleEntity) {
            this.enderWhaleEntity = enderWhaleEntity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        @Override
        public boolean method_6264() {
            return true;
        }

        @Override
        public void method_6268() {
            class_243 vec3d = this.enderWhaleEntity.method_18798();
            this.enderWhaleEntity.method_36456(-((float) class_3532.method_15349(vec3d.field_1352, vec3d.field_1350)) * 57.295776F);
            this.enderWhaleEntity.field_6283 = this.enderWhaleEntity.method_36454();
        }
    }

    private static class TemptGoal extends class_1352 {
        private static final class_4051 TEMPTING_ENTITY_PREDICATE = class_4051.method_36626().method_18418(16.0D).method_36627();
        private final class_4051 predicate;
        private final EnderWhaleEntity enderWhaleEntity;
        private final double speed;
        private double lastPlayerX;
        private double lastPlayerY;
        private double lastPlayerZ;
        private double lastPlayerPitch;
        private double lastPlayerYaw;
        protected class_1657 closestPlayer;
        private int cooldown;
        private final class_1856 food;

        public TemptGoal(EnderWhaleEntity entity, double speed, class_1856 food) {
            this.enderWhaleEntity = entity;
            this.speed = speed;
            this.food = food;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
            this.predicate = TEMPTING_ENTITY_PREDICATE.method_33335().method_18420(this::isTemptedBy);
        }

        @Override
        public boolean method_6264() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            } else {
                this.closestPlayer = this.enderWhaleEntity.method_37908().method_18462(this.predicate, this.enderWhaleEntity);
                return this.closestPlayer != null;
            }
        }

        private boolean isTemptedBy(class_1309 entity) {
            return this.food.method_8093(entity.method_6047()) || this.food.method_8093(entity.method_6079());
        }

        @Override
        public boolean method_6266() {
            if (this.enderWhaleEntity.method_5858(this.closestPlayer) < 36.0D) {
                if (this.closestPlayer.method_5649(this.lastPlayerX, this.lastPlayerY, this.lastPlayerZ) > 0.010000000000000002D) {
                    return false;
                }

                if (Math.abs((double) this.closestPlayer.method_36455() - this.lastPlayerPitch) > 5.0D || Math.abs((double) this.closestPlayer.method_36454() - this.lastPlayerYaw) > 5.0D) {
                    return false;
                }
            } else {
                this.lastPlayerX = this.closestPlayer.method_23317();
                this.lastPlayerY = this.closestPlayer.method_23318();
                this.lastPlayerZ = this.closestPlayer.method_23321();
            }

            this.lastPlayerPitch = (double) this.closestPlayer.method_36455();
            this.lastPlayerYaw = (double) this.closestPlayer.method_36454();

            return this.method_6264();
        }

        @Override
        public void method_6269() {
            this.lastPlayerX = this.closestPlayer.method_23317();
            this.lastPlayerY = this.closestPlayer.method_23318();
            this.lastPlayerZ = this.closestPlayer.method_23321();
        }

        @Override
        public void method_6270() {
            this.closestPlayer = null;
            this.enderWhaleEntity.method_5942().method_6340();
            this.cooldown = 100;
        }

        @Override
        public void method_6268() {
            this.enderWhaleEntity.method_5988().method_6226(this.closestPlayer, (float) (this.enderWhaleEntity.method_5986() + 20), (float) this.enderWhaleEntity.method_5978());
            if (this.enderWhaleEntity.method_5858(this.closestPlayer) < 9.25D) {
                this.enderWhaleEntity.method_5942().method_6340();
            } else {
                this.enderWhaleEntity.method_5942().method_6335(this.closestPlayer, this.speed);
            }

        }

    }

    static {
        ALWAYS_SADDLED = class_2945.method_12791(EnderWhaleEntity.class, class_2943.field_13323);
        BOOST_TIME = class_2945.method_12791(EnderWhaleEntity.class, class_2943.field_13327);
    }

}
