package net.adventurez.entity;

import java.util.EnumSet;

import org.jetbrains.annotations.Nullable;

import net.adventurez.init.ConfigInit;
import net.adventurez.init.EntityInit;
import net.adventurez.init.ParticleInit;
import net.adventurez.init.SoundInit;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1510;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1588;
import net.minecraft.class_1606;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2945.class_9222;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public class EnderwarthogEntity extends class_1588 {

    public static final class_2940<Boolean> RARE_VARIANT;
    public static final class_2940<Boolean> BITE_ATTACK;
    private int sprintedTicker = 0;

    public EnderwarthogEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 10;
    }

    public static class_5132.class_5133 createEnderwarthogAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 60.0D).method_26868(class_5134.field_23719, 0.26D).method_26868(class_5134.field_23724, 4.0D)
                .method_26868(class_5134.field_23718, 0.5D).method_26868(class_5134.field_23721, 9.0D).method_26868(class_5134.field_23722, 5.0D)
                .method_26868(class_5134.field_23717, 38.0D);
    }

    public static boolean canSpawn(class_1299<EnderwarthogEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        class_2680 blockState = world.method_8320(pos);
        return world.method_8407() != class_1267.field_5801 && class_1588.method_20679(world, pos, random) && class_1588.method_20636(type, world, spawnReason, pos, random)
                && random.method_43048(6) == 0 && class_1948.method_8662(world, pos, blockState, blockState.method_26227(), EntityInit.ENDERWARTHOG);
    }

    @Override
    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new SprintAttackGoal(this));
        this.field_6201.method_6277(2, new HeadAttackGoal(this, 1.0D, true));
        this.field_6201.method_6277(3, new class_1394(this, 0.85D));
        this.field_6201.method_6277(4, new class_1361(this, class_1657.class, 6.0F));
        this.field_6201.method_6277(5, new class_1376(this));
        this.field_6185.method_6277(1, new class_1400<>(this, class_1657.class, true));
        this.field_6185.method_6277(2, (new class_1399(this, new Class[] { EnderwarthogEntity.class })));
        this.field_6185.method_6277(3, (new class_1399(this, new Class[] { class_1510.class })));
        this.field_6185.method_6277(4, (new class_1399(this, new Class[] { class_1560.class })));
        this.field_6185.method_6277(5, (new class_1399(this, new Class[] { class_1559.class })));
        this.field_6185.method_6277(6, (new class_1399(this, new Class[] { class_1606.class })));
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("SprintTicker", this.sprintedTicker);
        tag.method_10556("RareVariant", this.field_6011.method_12789(RARE_VARIANT));
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.sprintedTicker = tag.method_10550("SprintTicker");
        this.field_6011.method_12778(RARE_VARIANT, tag.method_10577("RareVariant"));
    }

    @Override
    protected void method_5693(class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(RARE_VARIANT, false);
        builder.method_56912(BITE_ATTACK, false);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608() && sprintedTicker > 0) {
            sprintedTicker--;
        }

    }

    @Override
    protected class_3414 method_5994() {
        return SoundInit.ENDERWARTHOG_IDLE_EVENT;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return SoundInit.ENDERWARTHOG_HURT_EVENT;
    }

    @Override
    protected class_3414 method_6002() {
        return SoundInit.ENDERWARTHOG_DEATH_EVENT;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(SoundInit.ENDERWARTHOG_WALK_EVENT, 0.15F, 1.0F);
    }

    @Override
    public boolean method_6121(class_1297 target) {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), SoundInit.ENDERWARTHOG_ATTACK_EVENT, class_3419.field_15251, 1.0F,
                0.8F + this.method_37908().method_8409().method_43057() * 0.4F);
        return super.method_6121(target);
    }

    @Override
    @Nullable
    public class_1315 method_5943(class_5425 serverWorldAccess, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        entityData = super.method_5943(serverWorldAccess, difficulty, spawnReason, entityData);
        if (spawnReason.equals(class_3730.field_16462))
            this.field_6011.method_12778(RARE_VARIANT, true);
        if ((spawnReason.equals(class_3730.field_16459) || spawnReason.equals(class_3730.field_16472)) && this.method_37908().method_8409().method_43057() <= ConfigInit.CONFIG.warthog_rare_chance) {
            this.field_6011.method_12778(RARE_VARIANT, true);
            this.method_5996(class_5134.field_23716).method_6192(this.method_45326(class_5134.field_23716) + 20.0D);
        }
        return entityData;
    }

    static {
        RARE_VARIANT = class_2945.method_12791(EnderwarthogEntity.class, class_2943.field_13323);
        BITE_ATTACK = class_2945.method_12791(EnderwarthogEntity.class, class_2943.field_13323);
    }

    private class HeadAttackGoal extends class_1366 {
        private final EnderwarthogEntity enderwarthogEntity;
        private int cooldown;

        public HeadAttackGoal(class_1314 mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
            this.enderwarthogEntity = (EnderwarthogEntity) mob;
        }

        @Override
        public boolean method_6264() {
            if (this.enderwarthogEntity.sprintedTicker > 0) {
                return false;
            } else
                return super.method_6264();
        }

        @Override
        protected void method_6288(class_1309 target) {
            if (method_53715(target) && this.cooldown <= 0) {
                this.enderwarthogEntity.field_6011.method_12778(BITE_ATTACK, true);
                this.method_28346();
                this.field_6503.method_6104(class_1268.field_5808);
                this.field_6503.method_6121(target);
            }
        }

        @Override
        public void method_6270() {
            super.method_6270();
            this.enderwarthogEntity.field_6011.method_12778(BITE_ATTACK, false);
        }
    }

    private class SprintAttackGoal extends class_1352 {
        private final EnderwarthogEntity enderwarthogEntity;
        private class_243 targetPos;
        private int cooldown;

        public SprintAttackGoal(EnderwarthogEntity enderwarthogEntity) {
            this.enderwarthogEntity = enderwarthogEntity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        @Override
        public boolean method_6264() {
            if (this.cooldown-- > 0) {
                return false;
            } else {
                class_1309 livingEntity = this.enderwarthogEntity.method_5968();
                if (livingEntity == null) {
                    return false;
                } else if (!livingEntity.method_5805()) {
                    return false;
                } else {
                    if (this.enderwarthogEntity.method_6057(livingEntity) && Math.abs(livingEntity.method_23318() - this.enderwarthogEntity.method_23318()) <= 3.0D && livingEntity.method_24828()) {
                        this.targetPos = livingEntity.method_19538();
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }

        @Override
        public boolean method_6266() {
            class_1309 livingEntity = this.enderwarthogEntity.method_5968();
            if (livingEntity == null) {
                return false;
            } else if (!livingEntity.method_5805()) {
                return false;
            } else if (this.attack(livingEntity, this.enderwarthogEntity.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321()))) {
                return false;
            } else if (this.enderwarthogEntity.method_5649(this.targetPos.method_10216(), this.targetPos.method_10214(), this.targetPos.method_10215()) < 10.0D) {
                return false;
            } else {
                if (!(livingEntity instanceof class_1657) || livingEntity.method_7325() || ((class_1657) livingEntity).method_7337()) {
                    return false;
                } else {
                    class_243 vec3d = new class_243(this.enderwarthogEntity.method_23317(), this.enderwarthogEntity.method_23320(), this.enderwarthogEntity.method_23321());
                    class_243 vec3d2 = new class_243(targetPos.method_10216() - this.enderwarthogEntity.method_23317(), targetPos.method_10214() + 1.8D, targetPos.method_10215() - this.enderwarthogEntity.method_23321()).method_1029().method_18805(8.0D,
                            0.0D, 8.0D);
                    class_3965 blockHitResult = this.enderwarthogEntity.method_37908()
                            .method_17742(new class_3959(vec3d, vec3d.method_1019(vec3d2), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, this.enderwarthogEntity));
                    return blockHitResult.method_17783() != class_239.class_240.field_1332 && !this.enderwarthogEntity.method_37908().method_8320(blockHitResult.method_17777().method_10087(3)).method_26215();
                }
            }
        }

        @Override
        public void method_6269() {
            double d = targetPos.method_10216() - this.enderwarthogEntity.method_23317();
            double e = targetPos.method_10215() - this.enderwarthogEntity.method_23321();
            this.targetPos = this.targetPos.method_1031(new class_243(d, 0.0D, e).method_1029().field_1352 * 10.0D, 0.0D, new class_243(d, 0.0D, e).method_1029().field_1350 * 10.0D);
        }

        @Override
        public void method_6268() {
            double d = targetPos.method_10216() - this.enderwarthogEntity.method_23317();
            double e = targetPos.method_10215() - this.enderwarthogEntity.method_23321();
            float q = (float) (class_3532.method_15349(e, d) * 57.2957763671875D) - 90.0F;
            this.enderwarthogEntity.method_36456(this.wrapDegrees(this.enderwarthogEntity.method_36454(), q, 90.0F));
            this.enderwarthogEntity.method_5784(class_1313.field_6308, new class_243(d, 0.0D, e).method_1029().method_1021(0.6D));
            if (!this.enderwarthogEntity.method_37908().method_8608()) {
                class_243 vec3d2 = new class_243(targetPos.method_10216() - this.enderwarthogEntity.method_23317(), targetPos.method_10214() + 1.8D, targetPos.method_10215() - this.enderwarthogEntity.method_23321()).method_1029();
                ((class_3218) method_37908()).method_14199(ParticleInit.SPRINT_PARTICLE, this.enderwarthogEntity.method_23322(0.7D), this.enderwarthogEntity.method_23319(),
                        this.enderwarthogEntity.method_23325(0.7D), 0, vec3d2.field_1352, 0.0D, vec3d2.field_1350, 1.0D);
            }

        }

        @Override
        public void method_6270() {
            this.cooldown = 100 + this.enderwarthogEntity.method_37908().method_8409().method_43048(100);
            this.enderwarthogEntity.method_19540(false);
            this.enderwarthogEntity.sprintedTicker = 40;
            super.method_6270();
        }

        private boolean attack(class_1309 target, double squaredDistance) {
            double d = (double) (this.enderwarthogEntity.method_17681() * 1.5F * this.enderwarthogEntity.method_17681() * 1.5F + target.method_17681());
            if (squaredDistance <= d) {
                this.enderwarthogEntity.method_6104(class_1268.field_5808);
                if (this.enderwarthogEntity.method_6121(target)) {
                    class_243 attackedPos = new class_243(target.method_23317(), target.method_23318(), target.method_23321());

                    if (!this.enderwarthogEntity.method_37908().method_8320(class_2338.method_49638(attackedPos).method_10074()).method_26215())
                        for (int i = 0; i < 30; i++) {
                            ((class_3218) method_37908()).method_14199(
                                    new class_2388(class_2398.field_11217, this.enderwarthogEntity.method_37908().method_8320(class_2338.method_49638(attackedPos).method_10074())),
                                    attackedPos.method_10216() + this.enderwarthogEntity.method_37908().method_8409().method_43058() * 2.5D - 1.25D,
                                    attackedPos.method_10214() + this.enderwarthogEntity.method_37908().method_8409().method_43058() * 0.2D,
                                    attackedPos.method_10215() + this.enderwarthogEntity.method_37908().method_8409().method_43058() * 2.5D - 1.25D, 4, 0.0D,
                                    this.enderwarthogEntity.method_37908().method_8409().method_43058() * 0.15D, 0.D, 1.0D);
                        }
                    target.method_18799(target.method_18798().method_1031(0.0D, 0.1D, 0.0D));
                    target.method_6005(3.0D, (double) class_3532.method_15374(this.enderwarthogEntity.method_36454() * 0.017453292F), (double) (-class_3532.method_15362(this.enderwarthogEntity.method_36454() * 0.017453292F)));
                }
                return true;
            } else {
                return false;
            }
        }

        private float wrapDegrees(float from, float to, float max) {
            float f = class_3532.method_15393(to - from);
            if (f > max) {
                f = max;
            }

            if (f < -max) {
                f = -max;
            }

            float g = from + f;
            if (g < 0.0F) {
                g += 360.0F;
            } else if (g > 360.0F) {
                g -= 360.0F;
            }

            return g;
        }
    }

}
