package net.adventurez.entity;

import net.adventurez.init.EntityInit;
import net.adventurez.init.SoundInit;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1367;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2945.class_9222;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;

public class IguanaEntity extends class_1429 {

    public static final class_2940<Boolean> OPEN_MOUTH;

    public IguanaEntity(class_1299<? extends IguanaEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createIguanaAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0D).method_26868(class_5134.field_23719, 0.22D);
    }

    public static boolean method_20663(class_1299<? extends class_1429> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_27852(class_2246.field_10534) && world.method_22335(pos, 0) > 8;
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1374(this, 1.8D));
        this.field_6201.method_6277(2, new class_1341(this, 1.0D));
        this.field_6201.method_6277(3, new class_1391(this, 1.25D, class_1856.method_8091(class_1802.field_8689), false));
        this.field_6201.method_6277(4, new class_1353(this, 1.25D));
        this.field_6201.method_6277(5, new class_1394(this, 1.0D));
        this.field_6201.method_6277(6, new class_1361(this, class_1657.class, 5.0F));
        this.field_6201.method_6277(7, new class_1376(this));
        this.field_6201.method_6277(8, new EatDeadBushGoal(this, 1.0D));
    }

    @Override
    protected void method_5693(class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(OPEN_MOUTH, false);
    }

    @Override
    protected class_3414 method_5994() {
        return SoundInit.IGUANA_IDLE_EVENT;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return SoundInit.IGUANA_HURT_EVENT;
    }

    @Override
    protected class_3414 method_6002() {
        return SoundInit.IGUANA_DEATH_EVENT;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(SoundInit.IGUANA_STEP_EVENT, 0.35F, 1.0F);
    }

    @Override
    public IguanaEntity method_5613(class_3218 serverWorld, class_1296 passiveEntity) {
        return EntityInit.IGUANA.method_5883(serverWorld);
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_1802.field_8689);
    }

    static {
        OPEN_MOUTH = class_2945.method_12791(IguanaEntity.class, class_2943.field_13323);
    }

    private class EatDeadBushGoal extends class_1367 {
        private final IguanaEntity iguanaEntity;

        public EatDeadBushGoal(IguanaEntity iguanaEntity, double speed) {
            super(iguanaEntity, speed, 12);
            this.iguanaEntity = iguanaEntity;
        }

        @Override
        public boolean method_6264() {
            return !this.iguanaEntity.method_6109() && !this.iguanaEntity.method_6479() && super.method_6264();
        }

        @Override
        public void method_6269() {
            super.method_6269();
            this.iguanaEntity.field_6011.method_12778(IguanaEntity.OPEN_MOUTH, true);
        }

        @Override
        public void method_6270() {
            super.method_6270();
            this.iguanaEntity.field_6011.method_12778(IguanaEntity.OPEN_MOUTH, false);
        }

        @Override
        public void method_6268() {
            if (!this.iguanaEntity.method_37908().method_8608() && this.method_6295()) {
                if (this.iguanaEntity.method_6032() < this.iguanaEntity.method_6063())
                    this.iguanaEntity.method_6025(2f);

                this.iguanaEntity.method_37908().method_22352(field_6512, false);
                this.iguanaEntity.method_6476(600);
            }
            super.method_6268();
        }

        @Override
        public double method_6291() {
            return 2.1D;
        }

        @Override
        protected int method_6293(class_1314 mob) {
            return 60 + mob.method_59922().method_43048(600);
        }

        @Override
        protected boolean method_6296(class_4538 world, class_2338 pos) {
            if (world.method_8320(pos).method_27852(class_2246.field_10428))
                return true;
            else
                return false;
        }
    }
}
