package net.adventurez.entity;

import java.util.UUID;

import net.adventurez.init.EntityInit;
import net.adventurez.init.SoundInit;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2945.class_9222;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_6019;
import org.jetbrains.annotations.Nullable;

public class MammothEntity extends class_1429 implements class_5354 {
    private static final class_6019 ANGER_TIME_RANGE;
    public static final class_2940<Integer> ATTACK_TICKS;
    private int angerTime;
    private UUID targetUuid;
    private int attackTicksLeft;

    public MammothEntity(class_1299<? extends MammothEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createMammothAttributes() {
        return class_1429.method_26827().method_26868(class_5134.field_23716, 40.0D).method_26868(class_5134.field_23719, 0.25D)
                .method_26868(class_5134.field_23717, 26.0D).method_26868(class_5134.field_23721, 7.0D).method_26868(class_5134.field_23722, 0.5D);
    }

    @Override
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296) EntityInit.MAMMOTH.method_5883(world);
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8602 || stack.method_7909() == class_1802.field_8471 || stack.method_7909() == class_1802.field_8256;
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1341(this, 1.0D));
        this.field_6201.method_6277(2, new class_1353(this, 1.1D));
        this.field_6201.method_6277(3, new MammothEntity.AttackGoal());
        this.field_6201.method_6277(4, new class_1379(this, 1.0D));
        this.field_6201.method_6277(5, new class_1376(this));
        this.field_6201.method_6277(6, new class_1361(this, class_1657.class, 6.0F));
        this.field_6185.method_6277(1, new MammothEntity.MammothRevengeGoal());
        this.field_6185.method_6277(2, new class_1400<>(this, class_1657.class, 10, true, false, this::method_29515));
        this.field_6185.method_6277(3, new class_5398<>(this, false));
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.method_29517(nbt);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.method_29512(this.method_37908(), nbt);
    }

    @Override
    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    @Override
    public void method_29514(int ticks) {
        this.angerTime = ticks;
    }

    @Override
    public int method_29507() {
        return this.angerTime;
    }

    @Override
    public void method_29513(@Nullable UUID uuid) {
        this.targetUuid = uuid;
    }

    @Override
    public UUID method_29508() {
        return this.targetUuid;
    }

    @Override
    protected class_3414 method_5994() {
        return this.method_6109() ? SoundInit.MAMMOTH_BABY_IDLE_EVENT : SoundInit.MAMMOTH_IDLE_EVENT;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return SoundInit.MAMMOTH_HIT_EVENT;
    }

    @Override
    protected class_3414 method_6002() {
        return SoundInit.MAMMOTH_DEATH_EVENT;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_15036, 0.15F, 1.0F);
    }

    @Override
    protected void method_5693(class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ATTACK_TICKS, this.attackTicksLeft);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            this.method_29510((class_3218) this.method_37908(), true);
        }
        if (this.attackTicksLeft > 0) {
            --this.attackTicksLeft;
            this.method_5841().method_12778(ATTACK_TICKS, this.attackTicksLeft);
        }

    }

    @Override
    protected float method_6120() {
        return 0.98F;
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        if (entityData == null) {
            entityData = new class_1296.class_4697(1.0F);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    static {
        ATTACK_TICKS = class_2945.method_12791(MammothEntity.class, class_2943.field_13327);
        ANGER_TIME_RANGE = class_4802.method_24505(20, 39);
    }

    private class AttackGoal extends class_1366 {
        public AttackGoal() {
            super(MammothEntity.this, 1.15D, true);
        }
    }

    private class MammothRevengeGoal extends class_1399 {

        public MammothRevengeGoal() {
            super(MammothEntity.this);
        }

        @Override
        public void method_6269() {
            super.method_6269();
            if (MammothEntity.this.method_6109()) {
                this.method_6317();
                this.method_6270();
            }

        }

        @Override
        public void method_6319(class_1308 mob, class_1309 target) {
            if (mob instanceof MammothEntity && !mob.method_6109()) {
                super.method_6319(mob, target);
            }

        }
    }
}
