package net.adventurez.entity;

import java.util.List;
import java.util.Optional;

import com.google.common.collect.ImmutableList;

import net.adventurez.init.SoundInit;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2945.class_9222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4140;
import net.minecraft.class_4538;
import net.minecraft.class_4836;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5418;
import net.minecraft.class_7;

public class PiglinBeastEntity extends class_1588 {
    public static final class_2940<Float> ATTACK_TICK_VISUAL = class_2945.method_12791(PiglinBeastEntity.class, class_2943.field_13320);
    public static final class_2940<Float> LEAD_ARM = class_2945.method_12791(PiglinBeastEntity.class, class_2943.field_13320);
    private float attackTick;
    public float armTick;
    private int makePiglinsAngry = 0;

    public PiglinBeastEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 30;
        this.method_5941(class_7.field_14, 8.0F);
    }

    public static class_5132.class_5133 createPiglinBeastAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 80.0D).method_26868(class_5134.field_23719, 0.225D)
                .method_26868(class_5134.field_23718, 0.5D).method_26868(class_5134.field_23721, 9.0D).method_26868(class_5134.field_23722, 2D)
                .method_26868(class_5134.field_23717, 38.0D);
    }

    @Override
    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new AttackGoal());
        this.field_6201.method_6277(4, new class_1394(this, 1.0D));
        this.field_6201.method_6277(5, new class_1361(this, class_1657.class, 12.0F));
        this.field_6201.method_6277(6, new class_1376(this));
        this.field_6201.method_6277(7, new class_1361(this, class_1308.class, 8.0F));
        this.field_6185.method_6277(1, new class_1400<>(this, class_1639.class, true));
        this.field_6185.method_6277(2, new class_1400<>(this, class_1657.class, true));
        this.field_6185.method_6277(3, new class_1400<>(this, BlazeGuardianEntity.class, true));
        this.field_6185.method_6277(4, (new class_1399(this, new Class[] { class_4836.class })));
    }

    @Override
    public void method_5958() {
        if (attackTick > 0F) {
            attackTick = attackTick - 0.08F;
            field_6011.method_12778(ATTACK_TICK_VISUAL, attackTick);
        }
        if (this.method_5968() instanceof class_1657) {
            makePiglinsAngry++;
            if (makePiglinsAngry == 600) {
                field_6011.method_12778(LEAD_ARM, 1F);
                getPiglins();
                this.method_37908().method_43129(null, this, SoundInit.PIGLINBEAST_SHOUT_EVENT, class_3419.field_15251, 1.0F, 1.0F);
                this.method_5996(class_5134.field_23719).method_6192(0.0D);
            }
            if (makePiglinsAngry > 600) {
                field_6011.method_12778(LEAD_ARM, field_6011.method_12789(LEAD_ARM) - 0.02F);
            }
            if (makePiglinsAngry == 650) {
                this.method_5996(class_5134.field_23719).method_6192(0.23D);
                makePiglinsAngry = 0;
            }
        }
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10548("AttackTick", this.attackTick);
        tag.method_10548("LeadArm", 0F);
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.attackTick = tag.method_10583("AttackTick");
        this.armTick = tag.method_10583("LeadArm");
    }

    @Override
    protected void method_5693(class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ATTACK_TICK_VISUAL, 0F);
        builder.method_56912(LEAD_ARM, 0F);
    }

    @Override
    public boolean method_5957(class_4538 world) {
        return !world.method_22345(this.method_5829());
    }

    @Override
    public boolean method_5974(double num) {
        return false;
    }

    @Override
    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801) {
            this.method_31472();
        }

    }

    @Override
    public boolean method_5822(boolean allowVehicles) {
        return false;
    }

    @Override
    protected class_3414 method_5994() {
        return SoundInit.PIGLINBEAST_IDLE_EVENT;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return SoundInit.PIGLINBEAST_HURT_EVENT;
    }

    @Override
    protected class_3414 method_6002() {
        return SoundInit.PIGLINBEAST_DEATH_EVENT;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(SoundInit.PIGLINBEAST_WALK_EVENT, 0.5F, 1.0F);
    }

    private class AttackGoal extends class_1366 {

        public AttackGoal() {
            super(PiglinBeastEntity.this, 1.0D, true);
        }

        @Override
        protected void method_6288(class_1309 target) {
            if (method_53715(target) && attackTick <= 0F) {
                this.field_6503.method_37908().method_43129(null, PiglinBeastEntity.this, SoundInit.PIGLINBEAST_CLUBSWING_EVENT, class_3419.field_15251, 1.0F, 1.0F);
                this.method_28346();
                this.field_6503.method_6121(target);
                attackTick = 1F;
            }
        }
    }

    public void getPiglins() {
        List<class_4836> list = this.method_37908().method_8390(class_4836.class, this.method_5829().method_1014(40D), class_1301.field_6155);
        for (int i = 0; i < list.size(); ++i) {
            angerNearbyPiglins(list.get(i));
        }
    }

    private static void angerNearbyPiglins(class_5418 piglin) {
        getNearbyPiglins(piglin).forEach((abstractPiglinEntity) -> {
            getNearestDetectedPlayer(abstractPiglinEntity).ifPresent((playerEntity) -> {
                becomeAngryWith(abstractPiglinEntity, playerEntity);
            });
        });
    }

    public static Optional<class_1657> getNearestDetectedPlayer(class_5418 piglin) {
        return piglin.method_18868().method_18896(class_4140.field_22354) ? piglin.method_18868().method_46873(class_4140.field_22354)
                : Optional.empty();
    }

    public static void becomeAngryWith(class_5418 piglin, class_1309 target) {
        piglin.method_18868().method_18875(class_4140.field_19293);
        piglin.method_18868().method_24525(class_4140.field_22333, target.method_5667(), 600L);

        if (target.method_5864() == class_1299.field_6097 && piglin.method_37908().method_8450().method_8355(class_1928.field_25402)) {
            piglin.method_18868().method_24525(class_4140.field_25361, true, 600L);
        }
        if (!piglin.method_37908().method_8608()) {
            piglin.method_5996(class_5134.field_23721).method_6192(piglin.method_45325(class_5134.field_23721) + 3.0D);
            piglin.method_6025(piglin.method_6063());
        }

    }

    private static List<class_5418> getNearbyPiglins(class_5418 piglin) {
        return (List<class_5418>) piglin.method_18868().method_46873(class_4140.field_25755).orElse(ImmutableList.of());
    }

}
