package net.adventurez.entity;

import java.util.List;

import net.adventurez.init.SoundInit;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1317;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1538;
import net.minecraft.class_1549;
import net.minecraft.class_1588;
import net.minecraft.class_1613;
import net.minecraft.class_1628;
import net.minecraft.class_1640;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1811;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class ShamanEntity extends SpellCastingEntity {

    public ShamanEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createShamanAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 40.0D).method_26868(class_5134.field_23719, 0.3D)
                .method_26868(class_5134.field_23721, 6.0D).method_26868(class_5134.field_23722, 1.0D).method_26868(class_5134.field_23717, 35.0D);
    }

    @Override
    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new LookAtTargetGoalShaman());
        this.field_6201.method_6277(2, new NormalAttack(this, 1.0D, false));
        this.field_6201.method_6277(2, new class_1338<>(this, class_1657.class, 8.0F, 0.7D, 0.9D));
        this.field_6201.method_6277(4, new SummonCompanionsGoal());
        this.field_6201.method_6277(5, new ThunderboltSpellGoal());
        this.field_6201.method_6277(7, new EffectSpellGoal());
        this.field_6201.method_6277(8, new class_1361(this, class_1657.class, 7.0F, 1.0F));
        this.field_6201.method_6277(9, new class_1379(this, 0.9D));
        this.field_6201.method_6277(10, new class_1361(this, class_1308.class, 8.0F));
        this.field_6185.method_6277(1, (new class_1399(this, new Class[] { class_1640.class })));
        this.field_6185.method_6277(2, (new class_1399(this, new Class[] { class_1642.class })));
        this.field_6185.method_6277(3, (new class_1399(this, new Class[] { class_1613.class })));
        this.field_6185.method_6277(3, (new class_1399(this, new Class[] { class_1628.class })));
        this.field_6185.method_6277(3, (new class_1399(this, new Class[] { class_1549.class })));
        this.field_6185.method_6277(4, (new class_1400<>(this, class_1657.class, true)).method_6330(300));
    }

    public static boolean canSpawn(class_1299<ShamanEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return (method_20680(type, world, spawnReason, pos, random) && world.method_8311(pos)) || spawnReason == class_3730.field_16469;

    }

    @Override
    public int method_5945() {
        return 1;
    }

    @Override
    protected class_3414 method_5994() {
        return SoundInit.SHAMAN_IDLE_EVENT;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return SoundInit.SHAMAN_HURT_EVENT;
    }

    @Override
    protected class_3414 method_6002() {
        return SoundInit.SHAMAN_DEATH_EVENT;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(SoundInit.SHAMAN_WALK_EVENT, 0.5F, 1.0F);
    }

    @Override
    public class_3414 getCastSpellSound() {
        return class_3417.field_14858;
    }

    private boolean tooManyCompanions() {
        List<class_1309> list = this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014(40D), class_1301.field_6155);
        if (!list.isEmpty()) {
            int spiders = 0;
            int othermobs = 0;
            for (int i = 0; i < list.size(); i++) {
                class_1309 entity = (class_1309) list.get(i);
                if (entity.method_5864() == class_1299.field_6084) {
                    spiders++;
                } else if (entity.method_5864() == class_1299.field_6051 || entity.method_5864() == class_1299.field_6137 || entity.method_5864() == class_1299.field_6079) {
                    othermobs++;
                }
                if (spiders >= 2 || othermobs >= 4) {
                    return true;
                }
            }
        }
        return false;
    }

    private class ThunderboltSpellGoal extends SpellCastingEntity.CastSpellGoal {
        private ThunderboltSpellGoal() {
            super();
        }

        @Override
        protected int getInitialCooldown() {
            return 200;
        }

        @Override
        public int getSpellTicks() {
            return 20;
        }

        @Override
        public int startTimeDelay() {
            return 20;
        }

        @Override
        public boolean method_6264() {
            class_1309 attacker = ShamanEntity.this.method_6065();
            if (super.method_6264() && attacker != null && attacker.method_6047().method_7909() instanceof class_1811 && ShamanEntity.this.method_5858(attacker) > 12
                    && ShamanEntity.this.method_37908().method_8419()) {
                return true;
            } else {
                return false;
            }
        }

        @Override
        public void castSpell() {
            class_1309 attacker = ShamanEntity.this.method_6065();
            if (attacker != null) {
                class_3218 serverWorld = (class_3218) attacker.method_37908();
                double posX = attacker.method_23317() + ShamanEntity.this.method_37908().method_8409().method_43048(3);
                double posY = attacker.method_23318();
                double posZ = attacker.method_23321() + ShamanEntity.this.method_37908().method_8409().method_43048(3);
                class_2338 pos = class_2338.method_49637(posX, posY, posZ);
                class_1538 lightningEntity = (class_1538) class_1299.field_6112.method_5883(attacker.method_37908());
                lightningEntity.method_5725(pos, 0.0F, 0.0F);
                serverWorld.method_8649(lightningEntity);
            }
        }

        @Override
        public class_3414 getSoundPrepare() {
            return class_3417.field_15193;
        }

        @Override
        public SpellCastingEntity.Spell getSpell() {
            return SpellCastingEntity.Spell.THUNDERBOLT;
        }
    }

    private class EffectSpellGoal extends SpellCastingEntity.CastSpellGoal {
        private EffectSpellGoal() {
            super();
        }

        @Override
        protected int getInitialCooldown() {
            return 200;
        }

        @Override
        public int getSpellTicks() {
            return 60;
        }

        @Override
        public int startTimeDelay() {
            return 10;
        }

        @Override
        public boolean method_6264() {
            if (!super.method_6264()) {
                return false;
            } else
                return true;
        }

        @Override
        public void castSpell() {
            class_1309 livingEntity = ShamanEntity.this.method_5968();
            if (livingEntity != null) {
                class_6880<class_1291> statusEffect;
                if (ShamanEntity.this.method_59922().method_43057() <= 0.5F) {
                    statusEffect = class_1294.field_5911;
                } else {
                    statusEffect = class_1294.field_5899;
                }
                livingEntity.method_6092(new class_1293(statusEffect, 120 + ShamanEntity.this.method_59922().method_43048(80), 1, false, false, true));
            }

        }

        @Override
        public class_3414 getSoundPrepare() {
            return class_3417.field_15193;
        }

        @Override
        public SpellCastingEntity.Spell getSpell() {
            return SpellCastingEntity.Spell.WITHERING;
        }
    }

    private class SummonCompanionsGoal extends SpellCastingEntity.CastSpellGoal {
        private SummonCompanionsGoal() {
            super();
        }

        @Override
        public boolean method_6264() {
            if (!super.method_6264() || tooManyCompanions()) {
                return false;
            } else
                return true;
        }

        @Override
        public int getSpellTicks() {
            return 140;
        }

        @Override
        public int startTimeDelay() {
            return 340;
        }

        @Override
        public void castSpell() {
            class_3218 serverWorld = (class_3218) ShamanEntity.this.method_37908();
            int spellCount = 0;
            for (int i = 0; i < 20; ++i) {
                class_2338 blockPos = ShamanEntity.this.method_24515().method_10069(-3 + ShamanEntity.this.method_59922().method_43048(6), ShamanEntity.this.method_59922().method_43048(3),
                        -3 + ShamanEntity.this.method_59922().method_43048(6));
                if (class_1317.method_20638(class_1299.field_6051, serverWorld, class_3730.field_16467, blockPos, serverWorld.method_8409())) {
                    spellCount++;
                    if (ShamanEntity.this.method_59922().method_43057() < 0.6F) {
                        class_1549 caveSpiderEntity = class_1299.field_6084.method_5883(serverWorld);
                        caveSpiderEntity.method_5725(blockPos, serverWorld.method_8409().method_43057() * 360F, 0.0F);
                        caveSpiderEntity.method_5943(serverWorld, serverWorld.method_8404(blockPos), class_3730.field_16467, null);
                        serverWorld.method_30771(caveSpiderEntity);
                    } else {
                        class_1308 mobEntity;
                        int randomInt = ShamanEntity.this.method_59922().method_43048(3);
                        if (randomInt == 0) {
                            mobEntity = class_1299.field_6051.method_5883(serverWorld);
                        } else if (randomInt == 1) {
                            mobEntity = class_1299.field_6137.method_5883(serverWorld);
                        } else {
                            mobEntity = class_1299.field_6079.method_5883(serverWorld);
                        }
                        mobEntity.method_5725(blockPos, serverWorld.method_8409().method_43057() * 360F, 0.0F);
                        mobEntity.method_5943(serverWorld, serverWorld.method_8404(blockPos), class_3730.field_16467, null);
                        serverWorld.method_30771(mobEntity);
                    }
                }
                if (spellCount >= 3) {
                    break;
                }
            }

        }

        @Override
        public class_3414 getSoundPrepare() {
            return class_3417.field_15193;
        }

        @Override
        public SpellCastingEntity.Spell getSpell() {
            return SpellCastingEntity.Spell.SUMMON_PUPPET;
        }
    }

    private class LookAtTargetGoalShaman extends SpellCastingEntity.LookAtTargetGoal {
        private LookAtTargetGoalShaman() {
            super();
        }

        @Override
        public void method_6268() {
            if (ShamanEntity.this.method_5968() != null) {
                ShamanEntity.this.method_5988().method_6226(ShamanEntity.this.method_5968(), (float) ShamanEntity.this.method_5986(), (float) ShamanEntity.this.method_5978());
            }

        }
    }

    private class NormalAttack extends class_1366 {
        private final ShamanEntity summonerEntity;

        public NormalAttack(class_1314 mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
            this.summonerEntity = (ShamanEntity) mob;
        }

        @Override
        public boolean method_6264() {
            class_1309 livingEntity = this.summonerEntity.method_5968();
            return livingEntity != null && livingEntity.method_5805() && this.summonerEntity.method_18395(livingEntity) && this.summonerEntity.method_5858(livingEntity) < 7.0D && super.method_6264();
        }

        @Override
        public boolean method_6266() {
            class_1309 livingEntity = this.field_6503.method_5968();
            if (livingEntity == null || this.summonerEntity.method_5858(livingEntity) > 5D) {
                return false;
            } else if (!livingEntity.method_5805()) {
                return false;
            } else if (!this.field_6503.method_18407(livingEntity.method_24515())) {
                return false;
            } else {
                return !(livingEntity instanceof class_1657) || !livingEntity.method_7325() && !((class_1657) livingEntity).method_7337();
            }
        }

    }

}
