package net.adventurez.entity;

import org.jetbrains.annotations.Nullable;

import net.adventurez.init.EntityInit;
import net.adventurez.init.SoundInit;
import net.adventurez.mixin.accessor.ProjectileEntityAccessor;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1380;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5418;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;

public class SoulReaperEntity extends class_1588 implements class_1603 {
    private final class_1380<SoulReaperEntity> bowAttackGoal = new class_1380<>(this, 1.0D, 40, 15.0F);
    private final class_1366 meleeAttackGoal = new class_1366(this, 1.2D, true) {
        @Override
        public void method_6270() {
            super.method_6270();
            SoulReaperEntity.this.method_19540(false);
        }

        @Override
        public void method_6269() {
            super.method_6269();
            SoulReaperEntity.this.method_19540(true);
        }
    };

    public SoulReaperEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_14, 8.0F);
        this.field_6194 = 30;
    }

    public static class_5132.class_5133 createSoulReaperAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, 0.25D).method_26868(class_5134.field_23716, 120.0D);
    }

    @Override
    public void method_5959() {
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(5, new class_1394(this, 1.0D));
        this.field_6201.method_6277(6, new class_1361(this, class_1657.class, 8.0F));
        this.field_6201.method_6277(7, new class_1376(this));
        this.field_6185.method_6277(1, (new class_1399(this, new Class[] { SoulReaperEntity.class })));
        this.field_6185.method_6277(2, new class_1400<>(this, class_1657.class, true));
        this.field_6185.method_6277(3, new class_1400<>(this, class_5418.class, true));
    }

    @Override
    @Nullable
    public class_1315 method_5943(class_5425 serverWorldAccess, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        entityData = super.method_5943(serverWorldAccess, difficulty, spawnReason, entityData);
        class_5819 random = this.method_37908().method_8409();
        this.method_5964(random, difficulty);
        this.method_5984(serverWorldAccess, random, difficulty);
        this.bowAttackGoal.method_6305(40);
        this.field_6201.method_6277(4, this.bowAttackGoal);
        if (spawnReason.equals(class_3730.field_16462) || spawnReason.equals(class_3730.field_16459) || spawnReason.equals(class_3730.field_16472)) {
            NightmareEntity nightmareEntity = EntityInit.NIGHTMARE.method_5883(this.method_37908());
            nightmareEntity.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), 0.0F);
            nightmareEntity.method_5943(serverWorldAccess, difficulty, spawnReason, null);
            serverWorldAccess.method_8649(nightmareEntity);
            this.method_5804(nightmareEntity);
        }
        return entityData;
    }

    @Override
    public boolean method_32316() {
        return false;
    }

    public static boolean canSpawn(class_1299<SoulReaperEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return (method_20680(type, world, spawnReason, pos, random) && world.method_8320(pos.method_10086(3)).method_26215()
                && world.method_8390(SoulReaperEntity.class, new class_238(pos).method_1014(60D), class_1301.field_6155).isEmpty() && random.method_43048(7) == 0)
                || spawnReason == class_3730.field_16469;
    }

    @Override
    public void method_5842() {
        super.method_5842();
        if (this.method_5854() instanceof class_1314) {
            class_1314 pathAwareEntity = (class_1314) this.method_5854();
            this.field_6283 = pathAwareEntity.field_6283;
        }

    }

    @Override
    public int method_5945() {
        return 1;
    }

    @Override
    public boolean method_6049(class_1293 effect) {
        return effect.method_5579() == class_1294.field_5920 ? false : super.method_6049(effect);
    }

    @Override
    public void method_5964(class_5819 random, class_1266 difficulty) {
        super.method_5964(random, difficulty);
        this.method_5673(class_1304.field_6173, new class_1799(class_1802.field_8102));
    }

    @Override
    public boolean method_6121(class_1297 target) {
        if (target instanceof class_1309 livingEntity) {
            livingEntity.method_6092(new class_1293(class_1294.field_5920, 300));
        }
        return super.method_6121(target);
    }

    @Override
    public void method_6007() {
        if (this.method_37908() != null && !this.method_37908().field_9236) {
            class_1309 target = this.method_5968();
            if (target != null) {
                if (this.method_5739(target) > 7F) {
                    if (this.method_6118(class_1304.field_6173).method_7909().equals(class_1802.field_22022)) {
                        this.method_5673(class_1304.field_6173, class_1799.field_8037);
                        this.method_5673(class_1304.field_6173, new class_1799(class_1802.field_8102));
                    }
                    this.field_6201.method_6277(4, this.bowAttackGoal);
                    this.field_6201.method_6280(this.meleeAttackGoal);
                } else {
                    this.method_5673(class_1304.field_6173, class_1799.field_8037);
                    this.method_5673(class_1304.field_6173, new class_1799(class_1802.field_22022));
                    this.field_6201.method_6277(4, this.meleeAttackGoal);
                    this.field_6201.method_6280(this.bowAttackGoal);
                }
            } else {
                if (this.method_6118(class_1304.field_6173).method_7909().equals(class_1802.field_8102)) {
                    this.field_6201.method_6277(4, this.bowAttackGoal);
                } else {
                    this.field_6201.method_6277(4, this.meleeAttackGoal);
                }
            }
        }
        super.method_6007();
    }

    @Override
    public void method_7105(class_1309 target, float pullProgress) {
        class_1799 itemStack = this.method_18808(this.method_5998(class_1675.method_18812(this, class_1802.field_8102)));
        class_1665 persistentProjectileEntity = this.createArrowProjectile(itemStack, pullProgress);
        double d = target.method_23317() - this.method_23317();
        double e = target.method_23323(0.3333333333333333D) - persistentProjectileEntity.method_23318();
        double f = target.method_23321() - this.method_23321();
        double g = (double) class_3532.method_15355((float) (d * d + f * f));
        persistentProjectileEntity.method_7485(d, e + g * 0.21D, f, 1.3F, (float) (14 - this.method_37908().method_8407().method_5461() * 4));
        this.method_5783(class_3417.field_14633, 1.0F, 1.0F / (this.method_59922().method_43057() * 0.4F + 0.8F));
        this.method_37908().method_8649(persistentProjectileEntity);
    }

    public class_1665 createArrowProjectile(class_1799 arrow, float damageModifier) {
        class_1799 blackarrow = new class_1799(class_1802.field_8107);
        class_1799 itemStack = this.method_5998(class_1675.method_18812(this, class_1802.field_8102));
        class_1665 persistentProjectileEntity = class_1675.method_18813(this, blackarrow, 4F, itemStack);
        if (persistentProjectileEntity instanceof class_1667 arrowEntity) {
            arrowEntity.method_7463(new class_1293(class_1294.field_5920, 200));
        }
        ((ProjectileEntityAccessor) persistentProjectileEntity).callSetPierceLevel((byte) 1);

        return persistentProjectileEntity;
    }

    @Override
    public boolean method_25938(class_1811 weapon) {
        return weapon == class_1802.field_8102;
    }

    @Override
    public void method_5673(class_1304 slot, class_1799 stack) {
        super.method_5673(slot, stack);
    }

    @Override
    public boolean method_5822(boolean allowVehicles) {
        return false;
    }

    @Override
    protected class_3414 method_5994() {
        return SoundInit.SOULREAPER_IDLE_EVENT;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return SoundInit.SOULREAPER_HURT_EVENT;
    }

    @Override
    protected class_3414 method_6002() {
        return SoundInit.SOULREAPER_DEATH_EVENT;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14955, 0.5F, 1.0F);
    }

}