package net.adventurez.entity;

import java.util.EnumSet;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2945.class_9222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_9381;
import org.jetbrains.annotations.Nullable;

public abstract class SpellCastingEntity extends class_1588 {
    public SpellCastingEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.spell = SpellCastingEntity.Spell.NONE;
    }

    private static final class_2940<Byte> SPELL;
    protected int spellTicks;
    private SpellCastingEntity.Spell spell;

    @Override
    protected void method_5693(class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SPELL, (byte) 0);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.spellTicks = tag.method_10550("SpellTicks");
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("SpellTicks", this.spellTicks);
    }

    public boolean isSpellcasting() {
        if (this.method_37908().method_8608()) {
            return (Byte) this.field_6011.method_12789(SPELL) > 0;
        } else {
            return this.spellTicks > 0;
        }
    }

    public void setSpell(SpellCastingEntity.Spell spell) {
        this.spell = spell;
        this.field_6011.method_12778(SPELL, (byte) spell.id);
    }

    protected SpellCastingEntity.Spell getSpell() {
        return !this.method_37908().method_8608() ? this.spell : SpellCastingEntity.Spell.byId((Byte) this.field_6011.method_12789(SPELL));
    }

    protected void method_5958() {
        super.method_5958();
        if (this.spellTicks > 0) {
            --this.spellTicks;
        }

    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608() && this.isSpellcasting() && !(this instanceof ShamanEntity)) {
            SpellCastingEntity.Spell spell = this.getSpell();
            float d = (float) spell.particleVelocity[0];
            float e = (float) spell.particleVelocity[1];
            float f = (float) spell.particleVelocity[2];
            float g = this.field_6283 * 0.017453292F + class_3532.method_15362((float) this.field_6012 * 0.6662F) * 0.25F;
            float h = class_3532.method_15362(g);
            float i = class_3532.method_15374(g);
            this.method_37908().method_8406(class_9381.method_58255(class_2398.field_11226, d, e, f), (float) this.method_23317() + (float) h * 0.92f, this.method_23318() + 2.32f,
                    this.method_23321() + (float) i * 0.92f, 0.0, 0.0, 0.0);
        }

    }

    protected int getSpellTicks() {
        return this.spellTicks;
    }

    protected abstract class_3414 getCastSpellSound();

    static {
        SPELL = class_2945.method_12791(SpellCastingEntity.class, class_2943.field_13319);
    }

    public static enum Spell {
        NONE(0, 0.0D, 0.0D, 0.0D), SUMMON_PUPPET(1, 0.01D, 0.01D, 0.015D), WITHERING(2, 0.01D, 0.01D, 0.015D), SHIELD(3, 0.01D, 0.01D, 0.01D), TELEPORT(4, 0.005D, 0.005D, 0.015D),
        THUNDERBOLT(5, 0.015D, 0.015D, 0.015D);

        private final int id;
        private final double[] particleVelocity;

        private Spell(int id, double particleVelocityX, double particleVelocityY, double particleVelocityZ) {
            this.id = id;
            this.particleVelocity = new double[] { particleVelocityX, particleVelocityY, particleVelocityZ };
        }

        public static SpellCastingEntity.Spell byId(int id) {
            SpellCastingEntity.Spell[] var1 = values();
            int var2 = var1.length;

            for (int var3 = 0; var3 < var2; ++var3) {
                SpellCastingEntity.Spell spell = var1[var3];
                if (id == spell.id) {
                    return spell;
                }
            }

            return NONE;
        }
    }

    public abstract class CastSpellGoal extends class_1352 {
        protected int spellCooldown;
        protected int startTime;

        protected CastSpellGoal() {
        }

        public boolean method_6264() {
            class_1309 livingEntity = SpellCastingEntity.this.method_5968();
            if (livingEntity != null && livingEntity.method_5805()) {
                if (SpellCastingEntity.this.isSpellcasting()) {
                    return false;
                } else {
                    return SpellCastingEntity.this.field_6012 >= this.startTime;
                }
            } else {
                return false;
            }
        }

        public boolean method_6266() {
            class_1309 livingEntity = SpellCastingEntity.this.method_5968();
            return livingEntity != null && livingEntity.method_5805() && this.spellCooldown > 0;
        }

        public void method_6269() {
            this.spellCooldown = this.getInitialCooldown();
            SpellCastingEntity.this.spellTicks = this.getSpellTicks();
            this.startTime = SpellCastingEntity.this.field_6012 + this.startTimeDelay();
            class_3414 soundEvent = this.getSoundPrepare();
            if (soundEvent != null) {
                SpellCastingEntity.this.method_5783(soundEvent, 1.0F, 1.0F);
            }

            SpellCastingEntity.this.setSpell(this.getSpell());
        }

        public void method_6268() {
            --this.spellCooldown;
            if (this.spellCooldown == 0) {
                this.castSpell();
                SpellCastingEntity.this.method_5783(SpellCastingEntity.this.getCastSpellSound(), 1.0F, 1.0F);
            }

        }

        protected abstract void castSpell();

        protected int getInitialCooldown() {
            return 20;
        }

        protected abstract int getSpellTicks();

        protected abstract int startTimeDelay();

        @Nullable
        protected abstract class_3414 getSoundPrepare();

        protected abstract SpellCastingEntity.Spell getSpell();
    }

    public class LookAtTargetGoal extends class_1352 {
        public LookAtTargetGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return SpellCastingEntity.this.getSpellTicks() > 0;
        }

        public void method_6269() {
            super.method_6269();
            SpellCastingEntity.this.field_6189.method_6340();
        }

        public void method_6270() {
            super.method_6270();
            SpellCastingEntity.this.setSpell(SpellCastingEntity.Spell.NONE);
        }

        public void method_6268() {
            if (SpellCastingEntity.this.method_5968() != null) {
                SpellCastingEntity.this.method_5988().method_6226(SpellCastingEntity.this.method_5968(), (float) SpellCastingEntity.this.method_5986(),
                        (float) SpellCastingEntity.this.method_5978());
            }

        }
    }
}
